/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.DataField;
import org.unidal.dal.jdbc.Readset;
import org.unidal.dal.jdbc.annotation.Attribute;
import org.unidal.dal.jdbc.annotation.Entity;
import org.unidal.dal.jdbc.annotation.Relation;
import org.unidal.dal.jdbc.annotation.SubObjects;
import org.unidal.dal.jdbc.annotation.Variable;
import org.unidal.dal.jdbc.entity.EntityInfo;
import org.unidal.dal.jdbc.entity.EntityInfoManager;
import org.unidal.dal.jdbc.query.QueryNaming;
import org.unidal.dal.jdbc.raw.RawEntity;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=EntityInfoManager.class)
public class DefaultEntityInfoManager
implements EntityInfoManager,
LogEnabled,
Initializable {
    @Inject
    private QueryNaming m_reservedKeyword;
    private Map<String, Class<?>> m_logicalNameToEntityClass = new HashMap();
    private Map<Class<?>, EntityInfo> m_entityClassToEntityInfo = new HashMap();
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public EntityInfo getEntityInfo(Class<?> entityClass) {
        EntityInfo info = this.m_entityClassToEntityInfo.get(entityClass);
        if (info == null) {
            throw new IllegalStateException(entityClass + " is not registered yet");
        }
        return info;
    }

    @Override
    public EntityInfo getEntityInfo(String logicalName) {
        Class<?> entityClass = this.m_logicalNameToEntityClass.get(logicalName);
        EntityInfo info = this.m_entityClassToEntityInfo.get(entityClass);
        if (info == null) {
            throw new IllegalStateException("No Entity is registered with logical name(" + logicalName + ")");
        }
        return info;
    }

    @Override
    public synchronized void register(Class<?> entityClass) {
        Class<?> otherClass;
        if (this.m_entityClassToEntityInfo.containsKey(entityClass)) {
            this.m_logger.debug(entityClass + " is already initialized yet");
            return;
        }
        Entity entity = entityClass.getAnnotation(Entity.class);
        if (entity == null) {
            throw new DalRuntimeException(entityClass + " should be annotated by Entity");
        }
        HashMap<DataField, Relation> relations = new HashMap<DataField, Relation>();
        LinkedHashMap<DataField, Attribute> attributes = new LinkedHashMap<DataField, Attribute>();
        HashMap<DataField, Variable> variables = new HashMap<DataField, Variable>();
        HashMap subobjects = new HashMap();
        Field[] fields = entityClass.getFields();
        int index = 0;
        for (Field field : fields) {
            Readset readset;
            Class<?> type = field.getType();
            if (type == DataField.class) {
                DataField dataField;
                if (!Modifier.isStatic(field.getModifiers())) {
                    throw new DalRuntimeException("Field " + field.getName() + " of " + entityClass + " should be modified as static");
                }
                Relation relation = field.getAnnotation(Relation.class);
                Attribute attribute = field.getAnnotation(Attribute.class);
                Variable variable = field.getAnnotation(Variable.class);
                try {
                    dataField = (DataField)field.get(null);
                }
                catch (Exception e) {
                    throw new DalRuntimeException("Can't get value of Field " + field.getName() + " of " + entityClass);
                }
                if (attribute != null) {
                    attributes.put(dataField, attribute);
                } else if (variable != null) {
                    variables.put(dataField, variable);
                } else if (relation != null) {
                    relations.put(dataField, relation);
                } else {
                    this.m_logger.warn("Field " + field.getName() + " of " + entityClass + " should be annotated by " + "Attribute or Relation");
                }
                if (dataField != null) {
                    dataField.setEntityClass(entityClass);
                    dataField.setIndex(index);
                }
                ++index;
                continue;
            }
            if (type != Readset.class) continue;
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new DalRuntimeException("Readset " + field.getName() + " of " + entityClass + " should be modified as static");
            }
            SubObjects subobject = field.getAnnotation(SubObjects.class);
            try {
                readset = (Readset)field.get(null);
            }
            catch (Exception e) {
                throw new DalRuntimeException("Can't get value of Field " + field.getName() + " of " + entityClass);
            }
            if (subobject == null) continue;
            subobjects.put(readset, subobject);
        }
        if (attributes.size() == 0 && entityClass != RawEntity.class) {
            this.m_logger.warn("No fields defined with type DataField in " + entityClass);
        }
        if ((otherClass = this.m_logicalNameToEntityClass.get(entity.logicalName())) != null) {
            throw new DalRuntimeException("Logical name(" + entity.logicalName() + ") has been used by " + otherClass + ", can't use it in " + entityClass);
        }
        this.m_logicalNameToEntityClass.put(entity.logicalName(), entityClass);
        EntityInfo info = new EntityInfo(entity, relations, attributes, variables, subobjects);
        this.m_entityClassToEntityInfo.put(entityClass, info);
    }

    public void initialize() throws InitializationException {
        this.register(RawEntity.class);
    }
}

