/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.DataField;
import org.unidal.dal.jdbc.Readset;
import org.unidal.dal.jdbc.annotation.Attribute;
import org.unidal.dal.jdbc.annotation.Entity;
import org.unidal.dal.jdbc.annotation.Relation;
import org.unidal.dal.jdbc.annotation.SubObjects;
import org.unidal.dal.jdbc.annotation.Variable;

public class EntityInfo {
    private Entity m_entity;
    private Map<DataField, Relation> m_relations;
    private Map<DataField, Attribute> m_attributes;
    private Map<DataField, Variable> m_variables;
    private Map<Readset<?>, SubObjects> m_subobjects;
    private DataField m_autoIncrementField;

    public EntityInfo(Entity entity, Map<DataField, Relation> relations, Map<DataField, Attribute> attributes, Map<DataField, Variable> variables, Map<Readset<?>, SubObjects> subobjects) {
        this.m_entity = entity;
        this.m_relations = relations;
        this.m_attributes = attributes;
        this.m_variables = variables;
        this.m_subobjects = subobjects;
        for (Map.Entry<DataField, Attribute> e : attributes.entrySet()) {
            Attribute attribute = e.getValue();
            if (attribute == null || !attribute.autoIncrement()) continue;
            this.m_autoIncrementField = e.getKey();
            break;
        }
    }

    public String getAlias() {
        return this.m_entity.alias();
    }

    public Attribute getAttribute(DataField dataField) {
        return this.m_attributes.get(dataField);
    }

    public Attribute getAttribute(String fieldName) {
        DataField dataField = null;
        for (DataField e : this.m_attributes.keySet()) {
            if (!e.getName().equals(fieldName)) continue;
            dataField = e;
        }
        if (dataField != null) {
            return this.m_attributes.get(dataField);
        }
        return null;
    }

    public List<DataField> getAttributeFields() {
        ArrayList<DataField> dataFields = new ArrayList<DataField>(this.m_attributes.size());
        dataFields.addAll(this.m_attributes.keySet());
        return dataFields;
    }

    public DataField getAutoIncrementField() {
        return this.m_autoIncrementField;
    }

    public DataField getFieldByName(String fieldName) {
        for (DataField e : this.m_variables.keySet()) {
            if (!e.getName().equals(fieldName)) continue;
            return e;
        }
        for (DataField e : this.m_attributes.keySet()) {
            if (!e.getName().equals(fieldName)) continue;
            return e;
        }
        throw new DalRuntimeException("No DataField with name(" + fieldName + ") defined");
    }

    public String getJoinClause(Readset<?> readset) {
        String[] names;
        SubObjects subobject = this.m_subobjects.get(readset);
        if (subobject == null) {
            return "1=1";
        }
        StringBuilder sb = new StringBuilder(1024);
        for (String name : names = subobject.value()) {
            if (name == null || name.length() <= 0) continue;
            for (Map.Entry<DataField, Relation> e : this.m_relations.entrySet()) {
                if (!e.getKey().getName().equals(name)) continue;
                if (sb.length() > 0) {
                    sb.append(" and ");
                }
                sb.append(e.getValue().join());
            }
        }
        return sb.toString();
    }

    public String getLogicalName() {
        return this.m_entity.logicalName();
    }

    public String[] getLogicalNameAndAlias(String name) {
        if (this.m_entity.logicalName().equals(name)) {
            return new String[]{name, this.m_entity.alias()};
        }
        for (Map.Entry<DataField, Relation> e : this.m_relations.entrySet()) {
            if (!e.getKey().getName().equals(name)) continue;
            return new String[]{e.getValue().logicalName(), e.getValue().alias()};
        }
        throw new DalRuntimeException("Table(" + name + ") has no relationship with table(" + this.m_entity.logicalName() + ")");
    }

    public Relation getRelation(String logicalName) {
        for (Map.Entry<DataField, Relation> e : this.m_relations.entrySet()) {
            if (!e.getKey().getName().equals(logicalName)) continue;
            return e.getValue();
        }
        return null;
    }

    public SubObjects getSubobjects(Readset<?> readset) {
        return this.m_subobjects.get(readset);
    }

    public Variable getVariable(DataField dataField) {
        return this.m_variables.get(dataField);
    }

    public boolean isRelation(String logicalName) {
        for (DataField dataField : this.m_relations.keySet()) {
            if (!dataField.getName().equals(logicalName)) continue;
            return true;
        }
        return false;
    }
}

