/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.query;

import org.unidal.dal.jdbc.DataField;

public class Parameter {
    public static final int TYPE_SINGLE_VALUE = 0;
    public static final int TYPE_ARRAY = 1;
    public static final int TYPE_ITERABLE = 2;
    private boolean m_in;
    private boolean m_out;
    private DataField m_field;
    private int m_outType;
    private int m_outScale;
    private int m_type;

    public Parameter(DataField field) {
        this.m_field = field;
        this.m_in = true;
    }

    public Parameter(DataField field, int outType, int outScale) {
        this(field, outType, outScale, false);
    }

    public Parameter(DataField field, int outType, int outScale, boolean isIn) {
        this.m_field = field;
        this.m_outType = outType;
        this.m_outScale = outScale;
        this.m_in = isIn;
        this.m_out = true;
    }

    public DataField getField() {
        return this.m_field;
    }

    public int getOutScale() {
        return this.m_outScale;
    }

    public int getOutType() {
        return this.m_outType;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isArray() {
        return this.m_type == 1;
    }

    public boolean isIn() {
        return this.m_in;
    }

    public boolean isIterable() {
        return this.m_type == 2;
    }

    public boolean isOut() {
        return this.m_out;
    }

    public boolean isSingleValue() {
        return this.m_type == 0;
    }

    public Parameter setType(int type) {
        this.m_type = type;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        if (this.m_out) {
            sb.append('#');
        } else {
            sb.append('$');
        }
        sb.append('{').append(this.m_field.getName()).append('}');
        return sb.toString();
    }
}

