/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.query.msyql;

import com.dianping.cat.Cat;
import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.unidal.dal.jdbc.DataField;
import org.unidal.dal.jdbc.DataObject;
import org.unidal.dal.jdbc.QueryDef;
import org.unidal.dal.jdbc.QueryType;
import org.unidal.dal.jdbc.datasource.DataSource;
import org.unidal.dal.jdbc.datasource.DataSourceManager;
import org.unidal.dal.jdbc.engine.QueryContext;
import org.unidal.dal.jdbc.entity.DataObjectAccessor;
import org.unidal.dal.jdbc.entity.EntityInfo;
import org.unidal.dal.jdbc.query.Parameter;
import org.unidal.helper.Stringizers;
import org.unidal.lookup.annotation.Inject;

public abstract class MysqlBaseHandler {
    @Inject
    private DataObjectAccessor m_accessor;
    @Inject
    private DataSourceManager m_dataSourceManager;

    protected PreparedStatement createPreparedStatement(QueryContext ctx, Connection conn) throws SQLException {
        QueryDef query = ctx.getQuery();
        QueryType type = query.getType();
        PreparedStatement ps = type == QueryType.SELECT ? (query.isStoreProcedure() ? conn.prepareCall(ctx.getSqlStatement(), 1003, 1007) : conn.prepareStatement(ctx.getSqlStatement(), 1003, 1007)) : conn.prepareStatement(ctx.getSqlStatement(), 1);
        return ps;
    }

    protected String getQueryName(QueryContext ctx) {
        QueryDef query = ctx.getQuery();
        EntityInfo entity = ctx.getEntityInfo();
        return entity.getLogicalName() + "." + query.getName();
    }

    protected void logCatEvent(QueryContext ctx) {
        DataSource ds = this.m_dataSourceManager.getDataSource(ctx.getDataSourceName());
        String url = ds.getDescriptor().getProperty("url", "no-url");
        String params = ctx.getParameterValues() == null ? null : Stringizers.forJson().from((Object)ctx.getParameterValues());
        Cat.logEvent((String)"SQL.Method", (String)ctx.getQuery().getType().name(), (String)"0", (String)params);
        Cat.logEvent((String)"SQL.Database", (String)url);
    }

    protected void retrieveGeneratedKeys(QueryContext ctx, ResultSet generatedKeys, DataObject proto) throws SQLException {
        EntityInfo entityInfo = ctx.getEntityInfo();
        DataField field = entityInfo.getAutoIncrementField();
        if (generatedKeys != null && generatedKeys.next()) {
            Object key = generatedKeys.getObject(1);
            this.m_accessor.setFieldValue(proto, field, key);
        }
    }

    protected void retrieveGeneratedKeys(QueryContext ctx, ResultSet generatedKeys, DataObject[] protos) throws SQLException {
        EntityInfo entityInfo = ctx.getEntityInfo();
        DataField field = entityInfo.getAutoIncrementField();
        for (DataObject proto : protos) {
            if (generatedKeys == null || !generatedKeys.next()) continue;
            Object key = generatedKeys.getObject(1);
            this.m_accessor.setFieldValue(proto, field, key);
        }
    }

    protected <T extends DataObject> void retrieveOutParameters(PreparedStatement ps, List<Parameter> parameters, T proto) throws SQLException {
        if (ps instanceof CallableStatement) {
            int len = parameters.size();
            CallableStatement cs = (CallableStatement)ps;
            for (int i = 0; i < len; ++i) {
                Parameter parameter = parameters.get(i);
                if (!parameter.isOut()) continue;
                Object value = cs.getObject(i + 1);
                this.m_accessor.setFieldValue(proto, parameter.getField(), value);
            }
        }
    }

    protected <T extends DataObject> void setupInOutParameters(QueryContext ctx, PreparedStatement ps, T proto, boolean prepareParameterValues) throws SQLException {
        List<Parameter> parameters = ctx.getParameters();
        int len = parameters.size();
        if (len > 0) {
            int index = 1;
            ArrayList<Object> m_parameterValues = prepareParameterValues ? new ArrayList<Object>() : null;
            int i = 0;
            while (i < len) {
                Parameter parameter = parameters.get(i);
                if (parameter.isIn()) {
                    Object value = this.m_accessor.getFieldValue(proto, parameter.getField());
                    if (parameter.isIterable()) {
                        Iterable iterable = (Iterable)value;
                        for (Object item : iterable) {
                            ps.setObject(index++, item);
                            if (!prepareParameterValues) continue;
                            m_parameterValues.add(item);
                        }
                        --index;
                    } else if (parameter.isArray()) {
                        int length = Array.getLength(value);
                        for (int j = 0; j < length; ++j) {
                            Object item;
                            item = Array.get(value, j);
                            ps.setObject(index++, item);
                            if (!prepareParameterValues) continue;
                            m_parameterValues.add(item);
                        }
                        --index;
                    } else {
                        ps.setObject(index, value);
                        if (prepareParameterValues) {
                            m_parameterValues.add(value);
                        }
                    }
                }
                if (parameter.isOut() && ps instanceof CallableStatement) {
                    int outType = parameter.getOutType();
                    CallableStatement cs = (CallableStatement)ps;
                    if (outType == 2 || outType == 3) {
                        cs.registerOutParameter(index, outType, parameter.getOutScale());
                    } else {
                        cs.registerOutParameter(index, outType);
                    }
                }
                ++i;
                ++index;
            }
            if (prepareParameterValues && m_parameterValues.size() > 0) {
                ctx.setParameterValues(m_parameterValues.toArray(new Object[0]));
            }
        }
    }
}

