/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.query.msyql;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.QueryType;
import org.unidal.dal.jdbc.engine.QueryContext;
import org.unidal.dal.jdbc.query.QueryResolver;
import org.unidal.dal.jdbc.query.token.SimpleTagToken;
import org.unidal.dal.jdbc.query.token.Token;
import org.unidal.dal.jdbc.query.token.TokenParser;
import org.unidal.dal.jdbc.query.token.TokenType;
import org.unidal.dal.jdbc.query.token.resolver.TokenResolver;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=QueryResolver.class)
public class MysqlQueryResolver
extends ContainerHolder
implements QueryResolver,
Initializable {
    @Inject
    private TokenParser m_tokenParser;
    private Map<String, TokenResolver> m_map;

    public void initialize() throws InitializationException {
        this.m_map = this.lookupMap(TokenResolver.class);
    }

    @Override
    public void resolve(QueryContext ctx) {
        List<Token> tokens = ctx.getQuery().parse(this.m_tokenParser);
        StringBuilder sb = new StringBuilder(1024);
        for (Token token : tokens) {
            TokenType type = token.getType();
            TokenResolver resolver = this.m_map.get(type.name());
            if (resolver == null) {
                throw new DalRuntimeException("No TokenResolver registered for token type (" + token + ")");
            }
            if (type == TokenType.IF) {
                sb.append(resolver.resolve(token, ctx));
                continue;
            }
            if (ctx.isSqlResolveDisabled()) continue;
            sb.append(resolver.resolve(token, ctx));
        }
        if (ctx.getQuery().isStoreProcedure() && ctx.getQuery().getType() == QueryType.SELECT && ctx.getOutFields().isEmpty()) {
            TokenResolver resolver = this.m_map.get(TokenType.FIELDS.name());
            Map<String, String> attributes = Collections.emptyMap();
            resolver.resolve(new SimpleTagToken("FIELDS", attributes), ctx);
        }
        ctx.setSqlStatement(sb.toString());
    }
}

