/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.query.msyql;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.DataObject;
import org.unidal.dal.jdbc.datasource.DataSourceException;
import org.unidal.dal.jdbc.engine.QueryContext;
import org.unidal.dal.jdbc.entity.DataObjectAssembly;
import org.unidal.dal.jdbc.query.ReadHandler;
import org.unidal.dal.jdbc.query.msyql.MysqlBaseHandler;
import org.unidal.dal.jdbc.transaction.TransactionManager;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ReadHandler.class, value="mysql")
public class MysqlReadHandler
extends MysqlBaseHandler
implements ReadHandler {
    @Inject
    private TransactionManager m_transactionManager;
    @Inject
    private DataObjectAssembly m_assembly;

    @Override
    public <T extends DataObject> List<T> executeQuery(QueryContext ctx) throws DalException {
        Transaction t = Cat.newTransaction((String)"SQL", (String)this.getQueryName(ctx));
        DataObject proto = ctx.getProto();
        Statement ps = null;
        t.addData(ctx.getSqlStatement());
        try {
            ps = this.createPreparedStatement(ctx, this.m_transactionManager.getConnection(ctx));
            if (ctx.getFetchSize() > 0) {
                ps.setFetchSize(ctx.getFetchSize());
            }
            this.setupInOutParameters(ctx, (PreparedStatement)ps, proto, true);
            this.logCatEvent(ctx);
            ResultSet rs = ps.executeQuery();
            List rows = this.m_assembly.assemble(ctx, rs);
            this.retrieveOutParameters((PreparedStatement)ps, ctx.getParameters(), proto);
            t.setStatus("0");
            List list = rows;
            return list;
        }
        catch (DataSourceException e) {
            t.setStatus(e.getClass().getSimpleName());
            Cat.logError((Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            t.setStatus(e.getClass().getSimpleName());
            Cat.logError((Throwable)e);
            throw new DalException(String.format("Error when executing query(%s) failed, proto: %s, message: %s.", ctx.getSqlStatement(), proto, e), e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    throw new DalRuntimeException("Error when closing PreparedStatement, message: " + e, e);
                }
            }
            t.complete();
            this.m_transactionManager.closeConnection();
        }
    }
}

