/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.query.msyql;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.DataObject;
import org.unidal.dal.jdbc.QueryType;
import org.unidal.dal.jdbc.datasource.DataSourceException;
import org.unidal.dal.jdbc.engine.QueryContext;
import org.unidal.dal.jdbc.query.WriteHandler;
import org.unidal.dal.jdbc.query.msyql.MysqlBaseHandler;
import org.unidal.dal.jdbc.transaction.TransactionManager;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=WriteHandler.class, value="mysql")
public class MysqlWriteHandler
extends MysqlBaseHandler
implements WriteHandler {
    @Inject
    private TransactionManager m_transactionManager;

    @Override
    public int executeUpdate(QueryContext ctx) throws DalException {
        Transaction t = Cat.newTransaction((String)"SQL", (String)this.getQueryName(ctx));
        DataObject proto = ctx.getProto();
        Statement ps = null;
        t.addData(ctx.getSqlStatement());
        try {
            ps = this.createPreparedStatement(ctx, this.m_transactionManager.getConnection(ctx));
            proto.beforeSave();
            this.setupInOutParameters(ctx, (PreparedStatement)ps, proto, false);
            this.logCatEvent(ctx);
            int rowCount = ps.executeUpdate();
            this.retrieveOutParameters((PreparedStatement)ps, ctx.getParameters(), proto);
            if (ctx.getQuery().getType() == QueryType.INSERT) {
                this.retrieveGeneratedKeys(ctx, ps.getGeneratedKeys(), proto);
            }
            t.setStatus("0");
            int n = rowCount;
            return n;
        }
        catch (DataSourceException e) {
            t.setStatus(e.getClass().getSimpleName());
            Cat.logError((Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            t.setStatus(e.getClass().getSimpleName());
            Cat.logError((Throwable)e);
            throw new DalException(String.format("Error when executing update(%s) failed, proto: %s, message: %s.", ctx.getSqlStatement(), proto, e), e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    throw new DalRuntimeException("Error when closing PreparedStatement, message: " + e, e);
                }
            }
            t.complete();
            this.m_transactionManager.closeConnection();
        }
    }

    @Override
    public <T extends DataObject> int[] executeUpdateBatch(QueryContext ctx, T[] protos) throws DalException {
        Transaction t = Cat.newTransaction((String)"SQL", (String)this.getQueryName(ctx));
        Statement ps = null;
        int[] rowCounts = new int[protos.length];
        boolean inTransaction = this.m_transactionManager.isInTransaction();
        boolean updated = false;
        t.addData(ctx.getSqlStatement());
        try {
            int i;
            ps = this.createPreparedStatement(ctx, this.m_transactionManager.getConnection(ctx));
            if (!inTransaction) {
                ps.getConnection().setAutoCommit(false);
            }
            if (ctx.getQuery().isStoreProcedure()) {
                for (i = 0; i < protos.length; ++i) {
                    ((DataObject)protos[i]).beforeSave();
                    this.setupInOutParameters(ctx, (PreparedStatement)ps, protos[i], false);
                    if (i == 0) {
                        this.logCatEvent(ctx);
                    }
                    rowCounts[i] = ps.executeUpdate();
                    updated = true;
                    this.retrieveOutParameters((PreparedStatement)ps, ctx.getParameters(), protos[i]);
                    if (ctx.getQuery().getType() != QueryType.INSERT) continue;
                    this.retrieveGeneratedKeys(ctx, ps.getGeneratedKeys(), (DataObject)protos[i]);
                }
            } else {
                for (i = 0; i < protos.length; ++i) {
                    ((DataObject)protos[i]).beforeSave();
                    this.setupInOutParameters(ctx, (PreparedStatement)ps, protos[i], false);
                    if (i == 0) {
                        this.logCatEvent(ctx);
                    }
                    ps.addBatch();
                }
                rowCounts = ps.executeBatch();
                updated = true;
                if (ctx.getQuery().getType() == QueryType.INSERT) {
                    this.retrieveGeneratedKeys(ctx, ps.getGeneratedKeys(), (DataObject[])protos);
                }
            }
            if (!inTransaction && updated) {
                ps.getConnection().commit();
                ps.getConnection().setAutoCommit(true);
            }
            t.setStatus("0");
            int[] i2 = rowCounts;
            return i2;
        }
        catch (DataSourceException e) {
            t.setStatus(e.getClass().getSimpleName());
            Cat.logError((Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            block23: {
                if (!inTransaction && updated) {
                    try {
                        ps.getConnection().rollback();
                        ps.getConnection().setAutoCommit(true);
                    }
                    catch (SQLException sqle) {
                        if (!(e instanceof SQLException)) break block23;
                        ((SQLException)e).setNextException(sqle);
                    }
                }
            }
            t.setStatus(e.getClass().getSimpleName());
            Cat.logError((Throwable)e);
            throw new DalException(String.format("Error when executing batch update(%s) failed, proto: %s, message: %s.", ctx.getSqlStatement(), ctx.getProto(), e), e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    throw new DalRuntimeException("Error when closing PreparedStatement, message: " + e, e);
                }
            }
            t.complete();
            this.m_transactionManager.closeConnection();
        }
    }
}

