/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.query.token;

import org.unidal.dal.jdbc.query.token.Token;
import org.unidal.dal.jdbc.query.token.TokenType;

public class ParameterToken
implements Token {
    private String m_token;
    private boolean m_dollarSign;
    private boolean m_numberSign;

    public ParameterToken(String token, boolean hasDollarSign, boolean hasNumberSign) {
        this.m_token = token;
        this.m_dollarSign = hasDollarSign;
        this.m_numberSign = hasNumberSign;
    }

    @Override
    public TokenType getType() {
        return TokenType.PARAM;
    }

    public String getParameterName() {
        return this.m_token;
    }

    public boolean isIn() {
        return this.m_dollarSign && !this.m_numberSign;
    }

    public boolean isOut() {
        return this.m_numberSign && !this.m_dollarSign;
    }

    public boolean isInOut() {
        return this.m_dollarSign && this.m_numberSign;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        if (this.m_dollarSign) {
            sb.append('$');
        } else if (this.m_numberSign) {
            sb.append('#');
        }
        sb.append('{').append(this.m_token).append('}');
        return sb.toString();
    }
}

