/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.query.token;

import java.util.LinkedHashMap;
import java.util.Map;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.query.token.Token;
import org.unidal.dal.jdbc.query.token.TokenType;

public class SimpleTagToken
implements Token {
    private String m_token;
    private Map<String, String> m_attributes;
    private TokenType m_tag;

    public SimpleTagToken(String token, Map<String, String> attributes) {
        String upperToken;
        this.m_token = upperToken = token.toUpperCase();
        this.m_attributes = new LinkedHashMap<String, String>(attributes);
        try {
            this.m_tag = TokenType.valueOf(upperToken);
        }
        catch (IllegalArgumentException e) {
            throw new DalRuntimeException("Unsupported token: " + upperToken, e);
        }
    }

    @Override
    public TokenType getType() {
        return this.m_tag;
    }

    public String getAttribute(String name, String defaultValue) {
        String value = this.m_attributes.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append('<').append(this.m_token);
        for (Map.Entry<String, String> entry : this.m_attributes.entrySet()) {
            sb.append(' ').append(entry.getKey()).append("='").append(entry.getValue()).append('\'');
        }
        sb.append("/>");
        return sb.toString();
    }
}

