/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.query.token;

import java.util.LinkedHashMap;
import java.util.Map;
import org.unidal.dal.jdbc.query.token.Token;
import org.unidal.dal.jdbc.query.token.TokenType;

public class StartTagToken
implements Token {
    private String m_token;
    private Map<String, String> m_attributes;
    private TokenType m_tag;

    public StartTagToken(String token, Map<String, String> attributes) {
        this.m_token = token;
        this.m_attributes = new LinkedHashMap<String, String>(attributes);
        this.m_tag = TokenType.valueOf(token);
    }

    @Override
    public TokenType getType() {
        return this.m_tag;
    }

    public String getAttribute(String name, String defaultValue) {
        String value = this.m_attributes.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append('<').append(this.m_token);
        for (Map.Entry<String, String> entry : this.m_attributes.entrySet()) {
            sb.append(' ').append(entry.getKey()).append("='").append(entry.getValue()).append('\'');
        }
        sb.append('>');
        return sb.toString();
    }
}

