/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.query.token.resolver;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.DataField;
import org.unidal.dal.jdbc.DataObject;
import org.unidal.dal.jdbc.engine.QueryContext;
import org.unidal.dal.jdbc.entity.DataObjectAccessor;
import org.unidal.dal.jdbc.query.token.EndTagToken;
import org.unidal.dal.jdbc.query.token.StartTagToken;
import org.unidal.dal.jdbc.query.token.Token;
import org.unidal.dal.jdbc.query.token.TokenType;
import org.unidal.dal.jdbc.query.token.resolver.TokenResolver;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TokenResolver.class, value="IF")
public class IfTokenResolver
implements TokenResolver,
Initializable {
    @Inject
    private DataObjectAccessor m_accessor;
    private Map<String, Expression> m_expressions = new HashMap<String, Expression>();

    private boolean evaluate(StartTagToken token, QueryContext ctx) {
        String type = token.getAttribute("type", "").toUpperCase();
        Expression expression = this.m_expressions.get(type);
        if (expression != null) {
            String fieldName = token.getAttribute("field", "");
            DataField dataField = ctx.getEntityInfo().getFieldByName(fieldName);
            DataObject proto = ctx.getProto();
            Object fieldValue = this.m_accessor.getFieldValue(proto, dataField);
            String tokenValue = token.getAttribute("value", null);
            boolean fieldUsed = proto.isFieldUsed(dataField);
            return expression.evaluate(token, fieldValue, tokenValue, fieldUsed);
        }
        throw new DalRuntimeException(String.format("Unsupported type: %s, please use one of %s instead", type, this.m_expressions.keySet()));
    }

    public void initialize() throws InitializationException {
        for (SimpleExpression e : SimpleExpression.values()) {
            this.m_expressions.put(e.getType(), e);
        }
    }

    @Override
    public String resolve(Token token, QueryContext ctx) {
        if (token.getType() != TokenType.IF) {
            throw new DalRuntimeException("Internal error: only IF token is supported by " + this.getClass());
        }
        if (token instanceof StartTagToken) {
            if (ctx.isWithinIfToken()) {
                throw new DalRuntimeException("IF token can't be nested");
            }
            ctx.setWithinIfToken(true);
            ctx.setSqlResolveDisabled(!this.evaluate((StartTagToken)token, ctx));
            return "";
        }
        if (token instanceof EndTagToken) {
            ctx.setWithinIfToken(false);
            ctx.setSqlResolveDisabled(false);
            return "";
        }
        throw new DalRuntimeException("Internal error: IF token can only be used as <IF ...> or </IF>");
    }

    static enum SimpleExpression implements Expression
    {
        NOT_NULL{

            @Override
            public boolean evaluate(StartTagToken token, Object fieldValue, String tokenValue, boolean fieldUsed) {
                return fieldUsed && fieldValue != null;
            }
        }
        ,
        NULL{

            @Override
            public boolean evaluate(StartTagToken token, Object fieldValue, String tokenValue, boolean fieldUsed) {
                return !fieldUsed || fieldValue == null;
            }
        }
        ,
        NOT_ZERO{

            @Override
            public boolean evaluate(StartTagToken token, Object fieldValue, String tokenValue, boolean fieldUsed) {
                return this.compare(fieldValue, "0") != 0;
            }
        }
        ,
        ZERO{

            @Override
            public boolean evaluate(StartTagToken token, Object fieldValue, String tokenValue, boolean fieldUsed) {
                return this.compare(fieldValue, "0") == 0;
            }
        }
        ,
        EQ{

            @Override
            public boolean evaluate(StartTagToken token, Object fieldValue, String tokenValue, boolean fieldUsed) {
                return this.compare(fieldValue, tokenValue) == 0;
            }
        }
        ,
        GT{

            @Override
            public boolean evaluate(StartTagToken token, Object fieldValue, String tokenValue, boolean fieldUsed) {
                return this.compare(fieldValue, tokenValue) > 0;
            }
        }
        ,
        GE{

            @Override
            public boolean evaluate(StartTagToken token, Object fieldValue, String tokenValue, boolean fieldUsed) {
                return this.compare(fieldValue, tokenValue) >= 0;
            }
        }
        ,
        LT{

            @Override
            public boolean evaluate(StartTagToken token, Object fieldValue, String tokenValue, boolean fieldUsed) {
                return this.compare(fieldValue, tokenValue) < 0;
            }
        }
        ,
        LE{

            @Override
            public boolean evaluate(StartTagToken token, Object fieldValue, String tokenValue, boolean fieldUsed) {
                return this.compare(fieldValue, tokenValue) <= 0;
            }
        }
        ,
        NE{

            @Override
            public boolean evaluate(StartTagToken token, Object fieldValue, String tokenValue, boolean fieldUsed) {
                return this.compare(fieldValue, tokenValue) != 0;
            }
        };


        protected int compare(Object v1, String v2) {
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null || v2 == null) {
                return v1 == null ? -1 : 1;
            }
            if (v1 instanceof String) {
                return ((String)v1).compareTo(v2);
            }
            if (v1 instanceof Boolean) {
                return ((Boolean)v1).compareTo(Boolean.valueOf(v2));
            }
            if (v1 instanceof Integer) {
                return (Integer)v1 - Double.valueOf(v2).intValue();
            }
            if (v1 instanceof Long) {
                return (int)((Long)v1 - Double.valueOf(v2).longValue());
            }
            if (v1 instanceof Double) {
                return ((Double)v1).compareTo(Double.parseDouble(v2));
            }
            return v1.toString().compareTo(v2);
        }

        @Override
        public String getType() {
            return this.name();
        }
    }

    public static interface Expression {
        public String getType();

        public boolean evaluate(StartTagToken var1, Object var2, String var3, boolean var4);
    }
}

