/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.query.token.resolver;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.DataField;
import org.unidal.dal.jdbc.annotation.Variable;
import org.unidal.dal.jdbc.engine.QueryContext;
import org.unidal.dal.jdbc.entity.DataObjectAccessor;
import org.unidal.dal.jdbc.query.Parameter;
import org.unidal.dal.jdbc.query.token.ParameterToken;
import org.unidal.dal.jdbc.query.token.Token;
import org.unidal.dal.jdbc.query.token.TokenType;
import org.unidal.dal.jdbc.query.token.resolver.TokenResolver;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TokenResolver.class, value="PARAM")
public class ParameterTokenResolver
implements TokenResolver {
    @Inject
    private DataObjectAccessor m_accessor;

    @Override
    public String resolve(Token token, QueryContext ctx) {
        if (token.getType() != TokenType.PARAM) {
            throw new DalRuntimeException("Internal error: only PARAM token is supported by " + this.getClass());
        }
        ParameterToken parameter = (ParameterToken)token;
        String fieldName = parameter.getParameterName();
        DataField dataField = ctx.getEntityInfo().getFieldByName(fieldName);
        if (parameter.isIn()) {
            Object value = this.m_accessor.getFieldValue(ctx.getProto(), dataField);
            if (ctx.isWithinInToken() && value != null && value.getClass().isArray()) {
                int length = Array.getLength(value);
                StringBuilder sb = new StringBuilder();
                if (length > 0) {
                    ctx.addParameter(new Parameter(dataField).setType(1));
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            sb.append(',');
                        }
                        sb.append('?');
                    }
                } else {
                    sb.append("null");
                }
                return sb.toString();
            }
            if (ctx.isWithinInToken() && value instanceof Iterable) {
                Iterable iterable = (Iterable)value;
                Iterator i = iterable.iterator();
                StringBuilder sb = new StringBuilder();
                if (i.hasNext()) {
                    ctx.addParameter(new Parameter(dataField).setType(2));
                    while (i.hasNext()) {
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append('?');
                        i.next();
                    }
                } else {
                    sb.append("null");
                }
                return sb.toString();
            }
            ctx.addParameter(new Parameter(dataField).setType(0));
            return "?";
        }
        if (parameter.isInOut()) {
            Variable variable = ctx.getEntityInfo().getVariable(dataField);
            ctx.addParameter(new Parameter(dataField, variable.sqlType(), variable.scale(), true).setType(0));
            return "?";
        }
        Variable variable = ctx.getEntityInfo().getVariable(dataField);
        ctx.addParameter(new Parameter(dataField, variable.sqlType(), variable.scale()).setType(0));
        return "?";
    }
}

