/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.query.token.resolver;

import java.util.HashSet;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.annotation.Relation;
import org.unidal.dal.jdbc.annotation.SubObjects;
import org.unidal.dal.jdbc.engine.QueryContext;
import org.unidal.dal.jdbc.entity.EntityInfo;
import org.unidal.dal.jdbc.mapping.TableProvider;
import org.unidal.dal.jdbc.mapping.TableProviderManager;
import org.unidal.dal.jdbc.query.QueryNaming;
import org.unidal.dal.jdbc.query.token.Token;
import org.unidal.dal.jdbc.query.token.TokenType;
import org.unidal.dal.jdbc.query.token.resolver.TokenResolver;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TokenResolver.class, value="TABLES")
public class TablesTokenResolver
implements TokenResolver {
    @Inject
    private TableProviderManager m_manager;
    @Inject
    private QueryNaming m_naming;

    private String getPhysicalName(QueryContext ctx, String logicalName) {
        TableProvider tableProvider = this.m_manager.getTableProvider(logicalName);
        String physicalTableName = tableProvider.getPhysicalTableName(ctx.getQueryHints(), logicalName);
        return physicalTableName;
    }

    @Override
    public String resolve(Token token, QueryContext ctx) {
        if (token.getType() != TokenType.TABLES) {
            throw new DalRuntimeException("Internal error: only TABLES token is supported by " + this.getClass());
        }
        switch (ctx.getQuery().getType()) {
            case SELECT: {
                EntityInfo entityInfo = ctx.getEntityInfo();
                SubObjects subobject = entityInfo.getSubobjects(ctx.getReadset());
                StringBuilder sb = new StringBuilder(256);
                String table = this.getPhysicalName(ctx, entityInfo.getLogicalName());
                sb.append(this.m_naming.getTable(table, entityInfo.getAlias()));
                if (subobject != null) {
                    String[] names = subobject.value();
                    HashSet<String> done = new HashSet<String>();
                    done.add(entityInfo.getLogicalName());
                    for (String name : names) {
                        if (name == null || name.length() <= 0 || done.contains(name)) continue;
                        done.add(name);
                        Relation relation = entityInfo.getRelation(name);
                        sb.append(", ");
                        sb.append(this.m_naming.getTable(this.getPhysicalName(ctx, relation.logicalName()), relation.alias()));
                    }
                }
                return sb.toString();
            }
            case INSERT: {
                throw new DalRuntimeException("TABLES token does not support query type: " + (Object)((Object)ctx.getQuery().getType()));
            }
            case UPDATE: {
                throw new DalRuntimeException("TABLES token does not support query type: " + (Object)((Object)ctx.getQuery().getType()));
            }
            case DELETE: {
                throw new DalRuntimeException("TABLES token does not support query type: " + (Object)((Object)ctx.getQuery().getType()));
            }
        }
        throw new DalRuntimeException("TABLES token does not support query type: " + (Object)((Object)ctx.getQuery().getType()));
    }
}

