/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.query.token.resolver;

import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.DataField;
import org.unidal.dal.jdbc.DataObject;
import org.unidal.dal.jdbc.annotation.Attribute;
import org.unidal.dal.jdbc.engine.QueryContext;
import org.unidal.dal.jdbc.entity.EntityInfo;
import org.unidal.dal.jdbc.query.Parameter;
import org.unidal.dal.jdbc.query.token.Token;
import org.unidal.dal.jdbc.query.token.TokenType;
import org.unidal.dal.jdbc.query.token.resolver.ExpressionResolver;
import org.unidal.dal.jdbc.query.token.resolver.TokenResolver;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TokenResolver.class, value="VALUES")
public class ValuesTokenResolver
implements TokenResolver {
    @Inject
    private ExpressionResolver m_expressionResolver;

    @Override
    public String resolve(Token token, QueryContext ctx) {
        if (token.getType() != TokenType.VALUES) {
            throw new DalRuntimeException("Internal error: only VALUES token is supported by " + this.getClass());
        }
        EntityInfo entityInfo = ctx.getEntityInfo();
        StringBuilder sb = new StringBuilder(1024);
        switch (ctx.getQuery().getType()) {
            case SELECT: {
                throw new DalRuntimeException("VALUES token does not support query type: " + (Object)((Object)ctx.getQuery().getType()));
            }
            case INSERT: {
                DataObject proto = ctx.getProto();
                for (DataField field : entityInfo.getAttributeFields()) {
                    Attribute attribute = entityInfo.getAttribute(field);
                    if (attribute != null) {
                        if (attribute.field().length() <= 0 || attribute.autoIncrement() && !proto.isFieldUsed(field)) continue;
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        if (!proto.isFieldUsed(field) && attribute.insertExpr().length() > 0) {
                            sb.append(this.m_expressionResolver.resolve(ctx, attribute.insertExpr()));
                            continue;
                        }
                        sb.append('?');
                        ctx.addParameter(new Parameter(field));
                        continue;
                    }
                    throw new DalRuntimeException("Internal error: No Attribute annotation defined for field: " + field);
                }
                break;
            }
            case UPDATE: {
                throw new DalRuntimeException("VALUES token does not support query type: " + (Object)((Object)ctx.getQuery().getType()));
            }
            case DELETE: {
                throw new DalRuntimeException("VALUES token does not support query type: " + (Object)((Object)ctx.getQuery().getType()));
            }
            default: {
                throw new DalRuntimeException("VALUES token does not support query type: " + (Object)((Object)ctx.getQuery().getType()));
            }
        }
        return sb.toString();
    }
}

