/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test;

import com.google.common.collect.Multimap;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.datasource.DataSourceManager;
import org.unidal.dal.jdbc.datasource.JdbcDataSourceDescriptorManager;
import org.unidal.dal.jdbc.raw.RawDao;
import org.unidal.dal.jdbc.raw.RawDataObject;
import org.unidal.dal.jdbc.test.DatabaseDumper;
import org.unidal.dal.jdbc.test.QueryResultBuilder;
import org.unidal.dal.jdbc.test.TableLoader;
import org.unidal.dal.jdbc.test.TableMaker;
import org.unidal.dal.jdbc.test.TestDataSourceManager;
import org.unidal.dal.jdbc.test.data.entity.DatabaseModel;
import org.unidal.dal.jdbc.test.data.transform.DefaultSaxParser;
import org.unidal.dal.jdbc.test.function.StringFunction;
import org.unidal.helper.Files;
import org.unidal.helper.Reflects;
import org.unidal.lookup.ContainerHolder;

public class DataSourceTestHelper
extends ContainerHolder
implements LogEnabled {
    private String m_dataSource;
    private Logger m_logger;

    public void createTables(String group) throws Exception {
        String resource = String.format("/META-INF/dal/jdbc/%s-codegen.xml", group);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException(String.format("Resource(%s) not found!", resource));
        }
        TableMaker maker = (TableMaker)((Object)this.lookup(TableMaker.class));
        maker.make(this.getDefaultDataSource(), in);
    }

    public void defineFunctions(Class<?> functionClass) throws DalException {
        List methods = Reflects.forMethod().getMethods(functionClass, (Reflects.IMemberFilter)Reflects.MethodFilter.PUBLIC_STATIC);
        for (Method method : methods) {
            if (method.getReturnType() == Void.TYPE) {
                this.m_logger.warn(String.format("Method(%s) return void, IGNORED!", method));
                continue;
            }
            String name = method.getName();
            String className = functionClass.getName();
            this.executeUpdate(String.format("CREATE ALIAS IF NOT EXISTS %s FOR \"%s.%s\"", name.toUpperCase(), className, name));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dumpDeltaTo(String baseXmlFile, String deltaXmlFile, String ... tables) throws Exception {
        DatabaseModel model;
        if (tables.length <= 0) return;
        DatabaseDumper dumper = (DatabaseDumper)this.lookup(DatabaseDumper.class);
        String ds = this.getDefaultDataSource();
        if (baseXmlFile != null) {
            File base = this.getTestResourceFile(baseXmlFile);
            if (!base.exists()) throw new IllegalStateException(String.format("Resource(%s) is not found!", base.getCanonicalPath()));
            String xml = Files.forIO().readFrom(base, "utf-8");
            DatabaseModel baseModel = DefaultSaxParser.parse(xml);
            model = dumper.dump(baseModel, ds, tables);
        } else {
            model = dumper.dump(null, ds, tables);
        }
        File target = this.getTestResourceFile(deltaXmlFile);
        Files.forIO().writeTo(target, model.toString());
    }

    public void dumpTo(String dataXmlFile, String ... tables) throws Exception {
        this.dumpDeltaTo(null, dataXmlFile, tables);
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public List<RawDataObject> executeQuery(String sql) throws DalException {
        RawDao dao = (RawDao)((Object)this.lookup(RawDao.class));
        return dao.executeQuery(this.getDefaultDataSource(), sql);
    }

    public void executeUpdate(String sql) throws DalException {
        RawDao dao = (RawDao)((Object)this.lookup(RawDao.class));
        dao.executeUpdate(this.getDefaultDataSource(), sql);
    }

    public String getDefaultDataSource() {
        return this.m_dataSource;
    }

    private File getTestResourceFile(String deltaXml) {
        File file;
        File base = new File("src/test/resources");
        if (deltaXml.startsWith("/")) {
            file = new File(base, deltaXml);
        } else {
            String packageName = ((Object)((Object)this)).getClass().getPackage().getName();
            file = new File(base, packageName.replace('.', '/') + "/" + deltaXml);
        }
        return file;
    }

    public void loadFrom(String dataXmlResource) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(dataXmlResource);
        if (in == null) {
            throw new IllegalArgumentException(String.format("Resource(%s) not found!", dataXmlResource));
        }
        TableLoader loader = (TableLoader)this.lookup(TableLoader.class);
        loader.loadFrom(this.getDefaultDataSource(), in);
        this.release(loader);
    }

    public void setDataSource(String dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setUp(MutablePlexusContainer container) throws Exception {
        Class<TestDataSourceManager> implementation = TestDataSourceManager.class;
        ComponentDescriptor descriptor = new ComponentDescriptor(implementation, container.getContainerRealm());
        descriptor.setRoleClass(DataSourceManager.class);
        descriptor.setRoleHint("default");
        Map index = (Map)Reflects.forField().getDeclaredFieldValue((Object)container, new String[]{"componentRegistry", "repository", "index"});
        for (SortedMap roleIndex : index.values()) {
            Multimap roleHintIndex = (Multimap)roleIndex.get(DataSourceManager.class.getName());
            if (roleHintIndex == null) continue;
            roleHintIndex.removeAll((Object)"default");
        }
        ComponentRequirement req = new ComponentRequirement();
        req.setRole(JdbcDataSourceDescriptorManager.class.getName());
        descriptor.addRequirement(req);
        container.addComponentDescriptor(descriptor);
        this.defineFunctions(StringFunction.class);
    }

    public void showQuery(String sql) throws DalException {
        long start = System.currentTimeMillis();
        List<RawDataObject> rowset = this.executeQuery(sql);
        long end = System.currentTimeMillis();
        System.out.println(new QueryResultBuilder().build(rowset));
        System.out.println(String.format("%s rows in set (%.3f sec)", rowset.size(), (double)(end - start) / 1000.0));
        System.out.println();
    }

    public void tearDown() throws Exception {
        this.executeUpdate("SHUTDOWN");
    }
}

