/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.junit.Before;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.datasource.DataSourceManager;
import org.unidal.dal.jdbc.raw.RawDao;
import org.unidal.dal.jdbc.raw.RawDataObject;
import org.unidal.dal.jdbc.test.DatabaseDumper;
import org.unidal.dal.jdbc.test.QueryResultBuilder;
import org.unidal.dal.jdbc.test.TableLoader;
import org.unidal.dal.jdbc.test.TableMaker;
import org.unidal.dal.jdbc.test.TestDataSourceManager;
import org.unidal.dal.jdbc.test.data.entity.DatabaseModel;
import org.unidal.dal.jdbc.test.data.transform.DefaultSaxParser;
import org.unidal.dal.jdbc.test.function.StringFunction;
import org.unidal.helper.Files;
import org.unidal.helper.Reflects;
import org.unidal.lookup.ComponentTestCase;

public abstract class JdbcTestCase
extends ComponentTestCase {
    private LoggerManager m_loggerManager;

    protected void createTables(String group) throws Exception {
        String resource = String.format("/META-INF/dal/jdbc/%s-codegen.xml", group);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException(String.format("Resource(%s) not found!", resource));
        }
        TableMaker maker = (TableMaker)((Object)this.lookup(TableMaker.class));
        maker.make(this.getDefaultDataSource(), in);
    }

    protected void defineFunctions(Class<?> functionClass) throws DalException {
        List methods = Reflects.forMethod().getMethods(functionClass, (Reflects.IMemberFilter)Reflects.MethodFilter.PUBLIC_STATIC);
        for (Method method : methods) {
            if (method.getReturnType() == Void.TYPE) {
                this.getLogger().warn(String.format("Method(%s) return void, IGNORED!", method));
                continue;
            }
            String name = method.getName();
            String className = functionClass.getName();
            this.executeUpdate(String.format("CREATE ALIAS IF NOT EXISTS %s FOR \"%s.%s\"", name.toUpperCase(), className, name));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void dumpDeltaTo(String dataXml, String deltaXml, String ... tables) throws Exception {
        DatabaseModel model;
        if (tables.length <= 0) return;
        DatabaseDumper dumper = (DatabaseDumper)this.lookup(DatabaseDumper.class);
        String ds = this.getDefaultDataSource();
        if (dataXml != null) {
            File base = this.getTestResourceFile(dataXml);
            if (!base.exists()) throw new IllegalStateException(String.format("Resource(%s) is not found!", base.getCanonicalPath()));
            String xml = Files.forIO().readFrom(base, "utf-8");
            DatabaseModel baseModel = DefaultSaxParser.parse(xml);
            model = dumper.dump(baseModel, ds, tables);
        } else {
            model = dumper.dump(null, ds, tables);
        }
        File target = this.getTestResourceFile(deltaXml);
        Files.forIO().writeTo(target, model.toString());
    }

    private File getTestResourceFile(String deltaXml) {
        File file;
        File base = new File("src/test/resources");
        if (deltaXml.startsWith("/")) {
            file = new File(base, deltaXml);
        } else {
            String packageName = ((Object)((Object)this)).getClass().getPackage().getName();
            file = new File(base, packageName.replace('.', '/') + "/" + deltaXml);
        }
        return file;
    }

    protected void dumpTo(String dataXml, String ... tables) throws Exception {
        this.dumpDeltaTo(null, dataXml, tables);
    }

    protected List<RawDataObject> executeQuery(String sql) throws DalException {
        RawDao dao = (RawDao)((Object)this.lookup(RawDao.class));
        return dao.executeQuery(this.getDefaultDataSource(), sql);
    }

    protected void executeUpdate(String sql) throws DalException {
        RawDao dao = (RawDao)((Object)this.lookup(RawDao.class));
        dao.executeUpdate(this.getDefaultDataSource(), sql);
    }

    protected abstract String getDefaultDataSource();

    protected Logger getLogger() {
        return this.m_loggerManager.getLoggerForComponent("");
    }

    protected void loadFrom(String dataXml) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(dataXml);
        if (in == null) {
            throw new IllegalArgumentException(String.format("Resource(%s) not found!", dataXml));
        }
        TableLoader loader = (TableLoader)this.lookup(TableLoader.class);
        loader.loadFrom(this.getDefaultDataSource(), in);
        this.release(loader);
    }

    @Before
    public void setUp() throws Exception {
        System.setProperty("devMode", "true");
        super.setUp();
        this.m_loggerManager = (LoggerManager)this.lookup(LoggerManager.class);
        this.defineComponent(DataSourceManager.class, TestDataSourceManager.class);
        this.defineFunctions(StringFunction.class);
    }

    protected void showQuery(String sql) throws DalException {
        long start = System.currentTimeMillis();
        List<RawDataObject> rowset = this.executeQuery(sql);
        long end = System.currentTimeMillis();
        System.out.println(new QueryResultBuilder().build(rowset));
        System.out.println(String.format("%s rows in set (%.3f sec)", rowset.size(), (double)(end - start) / 1000.0));
        System.out.println();
    }

    public void tearDown() throws Exception {
        try {
            this.executeUpdate("SHUTDOWN");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.tearDown();
    }
}

