/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.raw.RawDao;
import org.unidal.dal.jdbc.raw.RawDataObject;
import org.unidal.dal.jdbc.test.DatabaseDumper;
import org.unidal.dal.jdbc.test.QueryResultBuilder;
import org.unidal.dal.jdbc.test.TableLoader;
import org.unidal.dal.jdbc.test.TableMaker;
import org.unidal.dal.jdbc.test.data.entity.DatabaseModel;
import org.unidal.dal.jdbc.test.data.transform.DefaultSaxParser;
import org.unidal.helper.Files;
import org.unidal.helper.Reflects;
import org.unidal.lookup.ContainerHolder;

public class JdbcTestHelper
extends ContainerHolder {
    private LoggerManager m_loggerManager;

    public void createTables(String dataSource, String group) throws Exception {
        String resource = String.format("/META-INF/dal/jdbc/%s-codegen.xml", group);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException(String.format("Resource(%s) not found!", resource));
        }
        TableMaker maker = (TableMaker)((Object)this.lookup(TableMaker.class));
        maker.make(dataSource, in);
    }

    public void defineFunctions(String dataSource, Class<?> functionClass) throws DalException {
        List methods = Reflects.forMethod().getMethods(functionClass, (Reflects.IMemberFilter)Reflects.MethodFilter.PUBLIC_STATIC);
        for (Method method : methods) {
            if (method.getReturnType() == Void.TYPE) {
                this.getLogger().warn(String.format("Method(%s) return void, IGNORED!", method));
                continue;
            }
            String name = method.getName();
            String className = functionClass.getName();
            this.executeUpdate(dataSource, String.format("CREATE ALIAS IF NOT EXISTS %s FOR \"%s.%s\"", name.toUpperCase(), className, name));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dumpDeltaTo(String dataSource, String dataXml, String deltaXml, String ... tables) throws Exception {
        DatabaseModel model;
        if (tables.length <= 0) return;
        DatabaseDumper dumper = (DatabaseDumper)this.lookup(DatabaseDumper.class);
        if (dataXml != null) {
            File base = this.getTestResourceFile(dataXml);
            if (!base.exists()) throw new IllegalStateException(String.format("Resource(%s) is not found!", base.getCanonicalPath()));
            String xml = Files.forIO().readFrom(base, "utf-8");
            DatabaseModel baseModel = DefaultSaxParser.parse(xml);
            model = dumper.dump(baseModel, dataSource, tables);
        } else {
            model = dumper.dump(null, dataSource, tables);
        }
        File target = this.getTestResourceFile(deltaXml);
        Files.forIO().writeTo(target, model.toString());
    }

    public void dumpTo(String dataSource, String dataXml, String ... tables) throws Exception {
        this.dumpDeltaTo(dataSource, null, dataXml, tables);
    }

    public List<RawDataObject> executeQuery(String dataSource, String sql) throws DalException {
        RawDao dao = (RawDao)((Object)this.lookup(RawDao.class));
        return dao.executeQuery(dataSource, sql);
    }

    public void executeUpdate(String dataSource, String sql) throws DalException {
        RawDao dao = (RawDao)((Object)this.lookup(RawDao.class));
        dao.executeUpdate(dataSource, sql);
    }

    public Logger getLogger() {
        return this.m_loggerManager.getLoggerForComponent("");
    }

    private File getTestResourceFile(String deltaXml) {
        File file;
        File base = new File("src/test/resources");
        if (deltaXml.startsWith("/")) {
            file = new File(base, deltaXml);
        } else {
            String packageName = ((Object)((Object)this)).getClass().getPackage().getName();
            file = new File(base, packageName.replace('.', '/') + "/" + deltaXml);
        }
        return file;
    }

    public void loadFrom(String dataSource, String dataXml) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(dataXml);
        if (in == null) {
            throw new IllegalArgumentException(String.format("Resource(%s) not found!", dataXml));
        }
        TableLoader loader = (TableLoader)this.lookup(TableLoader.class);
        loader.loadFrom(dataSource, in);
        this.release(loader);
    }

    public void setUp() throws Exception {
        System.setProperty("devMode", "true");
        this.m_loggerManager = (LoggerManager)this.lookup(LoggerManager.class);
    }

    public void showQuery(String dataSource, String sql) throws DalException {
        long start = System.currentTimeMillis();
        List<RawDataObject> rowset = this.executeQuery(dataSource, sql);
        long end = System.currentTimeMillis();
        System.out.println(new QueryResultBuilder().build(rowset));
        System.out.println(String.format("%s rows in set (%.3f sec)", rowset.size(), (double)(end - start) / 1000.0));
        System.out.println();
    }

    public void tearDown(String dataSource) throws Exception {
        this.executeUpdate(dataSource, "SHUTDOWN");
    }
}

