/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unidal.dal.jdbc.raw.RawDataObject;
import org.unidal.lookup.annotation.Named;

@Named
public class QueryResultBuilder {
    public String build(List<RawDataObject> rowset) {
        StringBuilder sb = new StringBuilder(4096);
        int size = rowset.size();
        if (size > 0) {
            Map<String, Integer> headers = this.buildHeaders(rowset);
            this.buildHeaders(sb, headers);
            for (RawDataObject row : rowset) {
                this.buildLine(sb, headers, row.getFields());
            }
            this.buildFooters(sb, headers);
        }
        return sb.toString();
    }

    private void buildChars(StringBuilder sb, char ch, int size) {
        for (int i = 0; i < size; ++i) {
            sb.append(ch);
        }
    }

    private void buildFooters(StringBuilder sb, Map<String, Integer> headers) {
        for (Integer len : headers.values()) {
            sb.append('+');
            this.buildChars(sb, '-', len + 2);
        }
        sb.append("+");
    }

    private Map<String, Integer> buildHeaders(List<RawDataObject> rowset) {
        int size = rowset.size();
        LinkedHashMap<String, Integer> headers = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < size; ++i) {
            RawDataObject row = rowset.get(i);
            for (Map.Entry<String, Object> field : row.getFields()) {
                String val;
                String name = field.getKey();
                Object value = field.getValue();
                Integer len = (Integer)headers.get(name);
                String string = val = value == null ? "" : value.toString();
                if (len == null) {
                    len = Math.max(name.length(), val.length());
                } else if (val.length() > len) {
                    len = val.length();
                }
                headers.put(name, len);
            }
        }
        return headers;
    }

    private void buildHeaders(StringBuilder sb, Map<String, Integer> headers) {
        for (Integer n : headers.values()) {
            sb.append('+');
            this.buildChars(sb, '-', n + 2);
        }
        sb.append("+\r\n");
        for (Map.Entry entry : headers.entrySet()) {
            String name = (String)entry.getKey();
            Integer len = (Integer)entry.getValue();
            sb.append("| ");
            sb.append(name);
            this.buildChars(sb, ' ', len + 1 - name.length());
        }
        sb.append("|\r\n");
        for (Integer n : headers.values()) {
            sb.append('+');
            this.buildChars(sb, '-', n + 2);
        }
        sb.append("+\r\n");
    }

    private void buildLine(StringBuilder sb, Map<String, Integer> headers, Set<Map.Entry<String, Object>> cols) {
        for (Map.Entry<String, Object> col : cols) {
            String value = col.getValue() == null ? "" : col.getValue().toString();
            Integer len = headers.get(col.getKey());
            sb.append("| ");
            sb.append(value);
            this.buildChars(sb, ' ', len + 1 - value.length());
        }
        sb.append("+\r\n");
    }
}

