/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test;

import java.util.ArrayList;
import java.util.List;
import org.unidal.dal.jdbc.test.meta.entity.EntityModel;
import org.unidal.dal.jdbc.test.meta.entity.MemberModel;
import org.unidal.dal.jdbc.test.meta.entity.PrimaryKeyModel;
import org.unidal.dal.jdbc.test.meta.transform.BaseVisitor2;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Named;

@Named(instantiationStrategy="per-lookup")
public class TableSchemaBuilder
extends BaseVisitor2 {
    private List<String> m_statements = new ArrayList<String>();
    private StringBuilder m_sb;

    public List<String> getStatements() {
        return this.m_statements;
    }

    private String guessType(MemberModel member) {
        String type = member.getValueType();
        Integer len = member.getLength();
        if ("int".equals(type)) {
            return String.format("int(%s)", len);
        }
        if ("long".equals(type)) {
            return "bigint";
        }
        if ("double".equals(type)) {
            return "double";
        }
        if ("String".equals(type)) {
            if (len == Integer.MAX_VALUE) {
                return "longtext";
            }
            if (len == 0xFFFFFF) {
                return "mediumtext";
            }
            if (len == 65535) {
                return "text";
            }
            return String.format("varchar(%s)", len);
        }
        if ("Date".equals(type)) {
            return "datetime";
        }
        if ("byte[]".equals(type)) {
            if (len == Integer.MAX_VALUE) {
                return "longblob";
            }
            if (len == 0xFFFFFF) {
                return "mediumblob";
            }
            if (len == 65535) {
                return "blob";
            }
        }
        throw new IllegalStateException("Unable to guest field type for " + type + "!");
    }

    private String quote(String field) {
        return "`" + field + "`";
    }

    private String quotes(String fieldList) {
        List fields = Splitters.by((char)',').trim().split(fieldList);
        StringBuilder sb = new StringBuilder(32);
        for (String field : fields) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("`").append(field).append("`");
        }
        return sb.toString();
    }

    private void trimComma() {
        int len = this.m_sb.length();
        if (len >= 3) {
            char ch0 = this.m_sb.charAt(len - 3);
            char ch1 = this.m_sb.charAt(len - 2);
            char ch2 = this.m_sb.charAt(len - 1);
            if (ch0 == ',' && ch1 == '\r' && ch2 == '\n') {
                this.m_sb.setCharAt(len - 3, ch1);
                this.m_sb.setCharAt(len - 2, ch2);
                this.m_sb.setLength(len - 1);
            }
        }
    }

    @Override
    protected void visitEntityChildren(EntityModel entity) {
        this.m_sb = new StringBuilder(1024);
        this.m_sb.append("CREATE TABLE ").append(this.quote(entity.getTable())).append(" (\r\n");
        super.visitEntityChildren(entity);
        this.trimComma();
        this.m_sb.append(") ENGINE=InnoDB DEFAULT CHARSET=utf8;\r\n");
        this.m_statements.add(this.m_sb.toString());
    }

    @Override
    protected void visitMemberChildren(MemberModel member) {
        this.m_sb.append("  ").append(this.quote(member.getField())).append(" ");
        this.m_sb.append(this.guessType(member));
        if (member.isNullable()) {
            this.m_sb.append(" DEFAULT NULL");
        } else {
            this.m_sb.append(" NOT NULL");
        }
        if (member.isAutoIncrement()) {
            this.m_sb.append(" AUTO_INCREMENT");
        }
        this.m_sb.append(",\r\n");
    }

    @Override
    protected void visitPrimaryKeyChildren(PrimaryKeyModel primaryKey) {
        this.m_sb.append("  PRIMARY KEY (");
        this.m_sb.append(this.quotes(primaryKey.getMembers()));
        this.m_sb.append("),\r\n");
    }
}

