/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.h2.jdbcx.JdbcConnectionPool;
import org.unidal.dal.jdbc.datasource.DataSource;
import org.unidal.dal.jdbc.datasource.DataSourceDescriptor;
import org.unidal.dal.jdbc.datasource.DataSourceManager;
import org.unidal.dal.jdbc.datasource.JdbcDataSourceDescriptor;

public class TestDataSourceManager
implements DataSourceManager {
    private Map<String, TestDataSource> m_dataSources = new LinkedHashMap<String, TestDataSource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DataSource getDataSource(String name) {
        TestDataSource dataSource = this.m_dataSources.get(name);
        if (dataSource == null) {
            Map<String, TestDataSource> map = this.m_dataSources;
            synchronized (map) {
                dataSource = this.m_dataSources.get(name);
                if (dataSource == null) {
                    dataSource = new TestDataSource(name);
                    this.m_dataSources.put(name, dataSource);
                }
            }
        }
        return dataSource;
    }

    @Override
    public synchronized List<String> getDataSourceNames() {
        return new ArrayList<String>(this.m_dataSources.keySet());
    }

    static class TestDataSource
    implements DataSource {
        private JdbcDataSourceDescriptor m_descriptor;
        private JdbcConnectionPool m_pool;

        public TestDataSource(String dataSourceName) {
            JdbcDataSourceDescriptor descriptor = new JdbcDataSourceDescriptor();
            String url = String.format("jdbc:h2:mem:%s;MODE=MySQL", dataSourceName);
            descriptor.setId(dataSourceName);
            descriptor.setType("h2");
            descriptor.setProperty("url", url);
            this.m_descriptor = descriptor;
            this.m_pool = JdbcConnectionPool.create((String)url, (String)"sa", (String)"sa");
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.m_pool.getConnection();
        }

        @Override
        public DataSourceDescriptor getDescriptor() {
            return this.m_descriptor;
        }

        @Override
        public void initialize(DataSourceDescriptor descriptor) {
        }

        public void reset() {
            this.m_pool.dispose();
        }
    }
}

