/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test.data.entity;

import java.util.ArrayList;
import java.util.List;
import org.unidal.dal.jdbc.test.data.BaseEntity;
import org.unidal.dal.jdbc.test.data.IVisitor;
import org.unidal.dal.jdbc.test.data.entity.TableModel;

public class DatabaseModel
extends BaseEntity<DatabaseModel> {
    private List<TableModel> m_tables = new ArrayList<TableModel>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitDatabase(this);
    }

    public DatabaseModel addTable(TableModel table) {
        this.m_tables.add(table);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatabaseModel) {
            DatabaseModel _o = (DatabaseModel)obj;
            return this.equals(this.m_tables, _o.getTables());
        }
        return false;
    }

    public TableModel findTable(String name) {
        for (TableModel table : this.m_tables) {
            if (!this.equals(table.getName(), name)) continue;
            return table;
        }
        return null;
    }

    public List<TableModel> getTables() {
        return this.m_tables;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_tables == null ? 0 : this.m_tables.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(DatabaseModel other) {
    }

    public TableModel removeTable(String name) {
        int len = this.m_tables.size();
        for (int i = 0; i < len; ++i) {
            TableModel table = this.m_tables.get(i);
            if (!this.equals(table.getName(), name)) continue;
            return this.m_tables.remove(i);
        }
        return null;
    }
}

