/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test.data.entity;

import java.util.ArrayList;
import java.util.List;
import org.unidal.dal.jdbc.test.data.BaseEntity;
import org.unidal.dal.jdbc.test.data.IVisitor;
import org.unidal.dal.jdbc.test.data.entity.ColModel;

public class RowModel
extends BaseEntity<RowModel> {
    private String m_status;
    private List<ColModel> m_cols = new ArrayList<ColModel>();
    private String m_id;

    public RowModel() {
    }

    public RowModel(String id) {
        this.m_id = id;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitRow(this);
    }

    public RowModel addCol(ColModel col) {
        this.m_cols.add(col);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RowModel) {
            RowModel _o = (RowModel)obj;
            return this.equals(this.m_id, _o.getId());
        }
        return false;
    }

    public ColModel findCol(String name) {
        for (ColModel col : this.m_cols) {
            if (!this.equals(col.getName(), name)) continue;
            return col;
        }
        return null;
    }

    public List<ColModel> getCols() {
        return this.m_cols;
    }

    public String getId() {
        return this.m_id;
    }

    public String getStatus() {
        return this.m_status;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(RowModel other) {
        this.assertAttributeEquals(other, "row", "id", this.m_id, other.getId());
        if (other.getStatus() != null) {
            this.m_status = other.getStatus();
        }
    }

    public ColModel removeCol(String name) {
        int len = this.m_cols.size();
        for (int i = 0; i < len; ++i) {
            ColModel col = this.m_cols.get(i);
            if (!this.equals(col.getName(), name)) continue;
            return this.m_cols.remove(i);
        }
        return null;
    }

    public RowModel setId(String id) {
        this.m_id = id;
        return this;
    }

    public RowModel setStatus(String status) {
        this.m_status = status;
        return this;
    }
}

