/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test.data.entity;

import java.util.ArrayList;
import java.util.List;
import org.unidal.dal.jdbc.test.data.BaseEntity;
import org.unidal.dal.jdbc.test.data.IVisitor;
import org.unidal.dal.jdbc.test.data.entity.RowModel;

public class TableModel
extends BaseEntity<TableModel> {
    private String m_name;
    private List<RowModel> m_rows = new ArrayList<RowModel>();

    public TableModel() {
    }

    public TableModel(String name) {
        this.m_name = name;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitTable(this);
    }

    public TableModel addRow(RowModel row) {
        this.m_rows.add(row);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableModel) {
            TableModel _o = (TableModel)obj;
            return this.equals(this.m_name, _o.getName());
        }
        return false;
    }

    public RowModel findRow(String id) {
        for (RowModel row : this.m_rows) {
            if (!this.equals(row.getId(), id)) continue;
            return row;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowModel findOrCreateRow(String id) {
        List<RowModel> list = this.m_rows;
        synchronized (list) {
            for (RowModel row : this.m_rows) {
                if (!this.equals(row.getId(), id)) continue;
                return row;
            }
            RowModel row = new RowModel(id);
            this.m_rows.add(row);
            return row;
        }
    }

    public String getName() {
        return this.m_name;
    }

    public List<RowModel> getRows() {
        return this.m_rows;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_name == null ? 0 : this.m_name.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(TableModel other) {
        this.assertAttributeEquals(other, "table", "name", this.m_name, other.getName());
    }

    public RowModel removeRow(String id) {
        int len = this.m_rows.size();
        for (int i = 0; i < len; ++i) {
            RowModel row = this.m_rows.get(i);
            if (!this.equals(row.getId(), id)) continue;
            return this.m_rows.remove(i);
        }
        return null;
    }

    public TableModel setName(String name) {
        this.m_name = name;
        return this;
    }
}

