/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test.data.transform;

import java.util.Stack;
import org.unidal.dal.jdbc.test.data.IVisitor;
import org.unidal.dal.jdbc.test.data.entity.ColModel;
import org.unidal.dal.jdbc.test.data.entity.DatabaseModel;
import org.unidal.dal.jdbc.test.data.entity.RowModel;
import org.unidal.dal.jdbc.test.data.entity.TableModel;

public abstract class BaseVisitor2
implements IVisitor {
    private Stack<Object> m_parents = new Stack();

    protected final <T> T getAncestor(int backLevels) {
        if (this.m_parents.isEmpty()) {
            return null;
        }
        if (backLevels == 1) {
            return (T)this.m_parents.peek();
        }
        int size = this.m_parents.size();
        if (backLevels <= size) {
            return (T)this.m_parents.get(size - backLevels);
        }
        return null;
    }

    protected final <T> T getParent() {
        return this.getAncestor(1);
    }

    protected final Stack<Object> getStack() {
        return this.m_parents;
    }

    @Override
    public final void visitCol(ColModel col) {
        this.m_parents.push(col);
        this.visitColChildren(col);
        this.m_parents.pop();
    }

    protected void visitColChildren(ColModel col) {
    }

    @Override
    public final void visitDatabase(DatabaseModel database) {
        this.m_parents.push(database);
        this.visitDatabaseChildren(database);
        this.m_parents.pop();
    }

    protected void visitDatabaseChildren(DatabaseModel database) {
        for (TableModel table : database.getTables()) {
            this.visitTable(table);
        }
    }

    @Override
    public final void visitRow(RowModel row) {
        this.m_parents.push(row);
        this.visitRowChildren(row);
        this.m_parents.pop();
    }

    protected void visitRowChildren(RowModel row) {
        for (ColModel col : row.getCols()) {
            this.visitCol(col);
        }
    }

    @Override
    public final void visitTable(TableModel table) {
        this.m_parents.push(table);
        this.visitTableChildren(table);
        this.m_parents.pop();
    }

    protected void visitTableChildren(TableModel table) {
        for (RowModel row : table.getRows()) {
            this.visitRow(row);
        }
    }
}

