/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test.data.transform;

import org.unidal.dal.jdbc.test.data.entity.ColModel;
import org.unidal.dal.jdbc.test.data.entity.DatabaseModel;
import org.unidal.dal.jdbc.test.data.entity.RowModel;
import org.unidal.dal.jdbc.test.data.entity.TableModel;
import org.unidal.dal.jdbc.test.data.transform.IMaker;
import org.xml.sax.Attributes;

public class DefaultSaxMaker
implements IMaker<Attributes> {
    @Override
    public ColModel buildCol(Attributes attributes) {
        String name = attributes.getValue("name");
        String key = attributes.getValue("key");
        ColModel col = new ColModel(name);
        if (key != null) {
            col.setKey(this.convert(Boolean.class, key, null));
        }
        return col;
    }

    @Override
    public DatabaseModel buildDatabase(Attributes attributes) {
        DatabaseModel database = new DatabaseModel();
        return database;
    }

    @Override
    public RowModel buildRow(Attributes attributes) {
        String status = attributes.getValue("status");
        String id = attributes.getValue("id");
        RowModel row = new RowModel(id);
        if (status != null) {
            row.setStatus(status);
        }
        return row;
    }

    @Override
    public TableModel buildTable(Attributes attributes) {
        String name = attributes.getValue("name");
        TableModel table = new TableModel(name);
        return table;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }
}

