/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test.data.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.unidal.dal.jdbc.test.data.IEntity;
import org.unidal.dal.jdbc.test.data.entity.ColModel;
import org.unidal.dal.jdbc.test.data.entity.DatabaseModel;
import org.unidal.dal.jdbc.test.data.entity.RowModel;
import org.unidal.dal.jdbc.test.data.entity.TableModel;
import org.unidal.dal.jdbc.test.data.transform.DefaultLinker;
import org.unidal.dal.jdbc.test.data.transform.DefaultSaxMaker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static DatabaseModel parse(InputSource is) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(DatabaseModel.class, is);
    }

    public static DatabaseModel parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(in));
    }

    public static DatabaseModel parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(reader));
    }

    public static DatabaseModel parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            Object currentObj = this.m_objs.pop();
            this.m_tags.pop();
            if (currentObj instanceof ColModel) {
                ColModel col = (ColModel)currentObj;
                col.setText(this.getText());
            }
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForCol(ColModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForDatabase(DatabaseModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"table".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under database!", qName));
        }
        TableModel table = this.m_maker.buildTable(attributes);
        this.m_linker.onTable(parentObj, table);
        this.m_objs.push(table);
        this.m_tags.push(qName);
    }

    private void parseForRow(RowModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"col".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under row!", qName));
        }
        ColModel col = this.m_maker.buildCol(attributes);
        this.m_linker.onCol(parentObj, col);
        this.m_objs.push(col);
        this.m_tags.push(qName);
    }

    private void parseForTable(TableModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"row".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under table!", qName));
        }
        RowModel row = this.m_maker.buildRow(attributes);
        this.m_linker.onRow(parentObj, row);
        this.m_objs.push(row);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("database".equals(qName)) {
            DatabaseModel database;
            this.m_entity = database = this.m_maker.buildDatabase(attributes);
            this.m_objs.push(database);
            this.m_tags.push(qName);
        } else if ("table".equals(qName)) {
            TableModel table;
            this.m_entity = table = this.m_maker.buildTable(attributes);
            this.m_objs.push(table);
            this.m_tags.push(qName);
        } else if ("row".equals(qName)) {
            RowModel row;
            this.m_entity = row = this.m_maker.buildRow(attributes);
            this.m_objs.push(row);
            this.m_tags.push(qName);
        } else if ("col".equals(qName)) {
            ColModel col;
            this.m_entity = col = this.m_maker.buildCol(attributes);
            this.m_objs.push(col);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = this.m_tags.peek();
            if (parent instanceof DatabaseModel) {
                this.parseForDatabase((DatabaseModel)parent, tag, qName, attributes);
            } else if (parent instanceof TableModel) {
                this.parseForTable((TableModel)parent, tag, qName, attributes);
            } else if (parent instanceof RowModel) {
                this.parseForRow((RowModel)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof ColModel)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForCol((ColModel)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

