/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test.meta.entity;

import java.util.ArrayList;
import java.util.List;
import org.unidal.dal.jdbc.test.meta.BaseEntity;
import org.unidal.dal.jdbc.test.meta.IVisitor;
import org.unidal.dal.jdbc.test.meta.entity.IndexModel;
import org.unidal.dal.jdbc.test.meta.entity.MemberModel;
import org.unidal.dal.jdbc.test.meta.entity.PrimaryKeyModel;
import org.unidal.dal.jdbc.test.meta.entity.QueryModel;
import org.unidal.dal.jdbc.test.meta.entity.ReadsetsModel;
import org.unidal.dal.jdbc.test.meta.entity.UpdatesetsModel;
import org.unidal.dal.jdbc.test.meta.entity.VarModel;

public class EntityModel
extends BaseEntity<EntityModel> {
    private String m_name;
    private String m_table;
    private String m_alias;
    private List<MemberModel> m_members = new ArrayList<MemberModel>();
    private VarModel m_var;
    private PrimaryKeyModel m_primaryKey;
    private ReadsetsModel m_readsets;
    private UpdatesetsModel m_updatesets;
    private List<QueryModel> m_queryDefs = new ArrayList<QueryModel>();
    private List<IndexModel> m_indexs = new ArrayList<IndexModel>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitEntity(this);
    }

    public EntityModel addIndex(IndexModel index) {
        this.m_indexs.add(index);
        return this;
    }

    public EntityModel addMember(MemberModel member) {
        this.m_members.add(member);
        return this;
    }

    public EntityModel addQuery(QueryModel query) {
        this.m_queryDefs.add(query);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityModel) {
            EntityModel _o = (EntityModel)obj;
            if (!this.equals(this.m_name, _o.getName())) {
                return false;
            }
            if (!this.equals(this.m_table, _o.getTable())) {
                return false;
            }
            if (!this.equals(this.m_alias, _o.getAlias())) {
                return false;
            }
            if (!this.equals(this.m_members, _o.getMembers())) {
                return false;
            }
            if (!this.equals(this.m_var, _o.getVar())) {
                return false;
            }
            if (!this.equals(this.m_primaryKey, _o.getPrimaryKey())) {
                return false;
            }
            if (!this.equals(this.m_readsets, _o.getReadsets())) {
                return false;
            }
            if (!this.equals(this.m_updatesets, _o.getUpdatesets())) {
                return false;
            }
            if (!this.equals(this.m_queryDefs, _o.getQueryDefs())) {
                return false;
            }
            return this.equals(this.m_indexs, _o.getIndexs());
        }
        return false;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public List<IndexModel> getIndexs() {
        return this.m_indexs;
    }

    public List<MemberModel> getMembers() {
        return this.m_members;
    }

    public String getName() {
        return this.m_name;
    }

    public PrimaryKeyModel getPrimaryKey() {
        return this.m_primaryKey;
    }

    public List<QueryModel> getQueryDefs() {
        return this.m_queryDefs;
    }

    public ReadsetsModel getReadsets() {
        return this.m_readsets;
    }

    public String getTable() {
        return this.m_table;
    }

    public UpdatesetsModel getUpdatesets() {
        return this.m_updatesets;
    }

    public VarModel getVar() {
        return this.m_var;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_name == null ? 0 : this.m_name.hashCode());
        hash = hash * 31 + (this.m_table == null ? 0 : this.m_table.hashCode());
        hash = hash * 31 + (this.m_alias == null ? 0 : this.m_alias.hashCode());
        hash = hash * 31 + (this.m_members == null ? 0 : this.m_members.hashCode());
        hash = hash * 31 + (this.m_var == null ? 0 : this.m_var.hashCode());
        hash = hash * 31 + (this.m_primaryKey == null ? 0 : this.m_primaryKey.hashCode());
        hash = hash * 31 + (this.m_readsets == null ? 0 : this.m_readsets.hashCode());
        hash = hash * 31 + (this.m_updatesets == null ? 0 : this.m_updatesets.hashCode());
        hash = hash * 31 + (this.m_queryDefs == null ? 0 : this.m_queryDefs.hashCode());
        hash = hash * 31 + (this.m_indexs == null ? 0 : this.m_indexs.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(EntityModel other) {
        if (other.getName() != null) {
            this.m_name = other.getName();
        }
        if (other.getTable() != null) {
            this.m_table = other.getTable();
        }
        if (other.getAlias() != null) {
            this.m_alias = other.getAlias();
        }
    }

    public EntityModel setAlias(String alias) {
        this.m_alias = alias;
        return this;
    }

    public EntityModel setName(String name) {
        this.m_name = name;
        return this;
    }

    public EntityModel setPrimaryKey(PrimaryKeyModel primaryKey) {
        this.m_primaryKey = primaryKey;
        return this;
    }

    public EntityModel setReadsets(ReadsetsModel readsets) {
        this.m_readsets = readsets;
        return this;
    }

    public EntityModel setTable(String table) {
        this.m_table = table;
        return this;
    }

    public EntityModel setUpdatesets(UpdatesetsModel updatesets) {
        this.m_updatesets = updatesets;
        return this;
    }

    public EntityModel setVar(VarModel var) {
        this.m_var = var;
        return this;
    }
}

