/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test.meta.transform;

import java.util.Stack;
import org.unidal.dal.jdbc.test.meta.IVisitor;
import org.unidal.dal.jdbc.test.meta.entity.EntitiesModel;
import org.unidal.dal.jdbc.test.meta.entity.EntityModel;
import org.unidal.dal.jdbc.test.meta.entity.IndexModel;
import org.unidal.dal.jdbc.test.meta.entity.MemberModel;
import org.unidal.dal.jdbc.test.meta.entity.ParamModel;
import org.unidal.dal.jdbc.test.meta.entity.PrimaryKeyModel;
import org.unidal.dal.jdbc.test.meta.entity.QueryModel;
import org.unidal.dal.jdbc.test.meta.entity.ReadsetModel;
import org.unidal.dal.jdbc.test.meta.entity.ReadsetsModel;
import org.unidal.dal.jdbc.test.meta.entity.UpdatesetModel;
import org.unidal.dal.jdbc.test.meta.entity.UpdatesetsModel;
import org.unidal.dal.jdbc.test.meta.entity.VarModel;

public abstract class BaseVisitor2
implements IVisitor {
    private Stack<Object> m_parents = new Stack();

    protected final <T> T getAncestor(int backLevels) {
        if (this.m_parents.isEmpty()) {
            return null;
        }
        if (backLevels == 1) {
            return (T)this.m_parents.peek();
        }
        int size = this.m_parents.size();
        if (backLevels <= size) {
            return (T)this.m_parents.get(size - backLevels);
        }
        return null;
    }

    protected final <T> T getParent() {
        return this.getAncestor(1);
    }

    protected final Stack<Object> getStack() {
        return this.m_parents;
    }

    @Override
    public final void visitEntities(EntitiesModel entities) {
        this.m_parents.push(entities);
        this.visitEntitiesChildren(entities);
        this.m_parents.pop();
    }

    protected void visitEntitiesChildren(EntitiesModel entities) {
        for (EntityModel entity : entities.getEntities()) {
            this.visitEntity(entity);
        }
    }

    @Override
    public final void visitEntity(EntityModel entity) {
        this.m_parents.push(entity);
        this.visitEntityChildren(entity);
        this.m_parents.pop();
    }

    protected void visitEntityChildren(EntityModel entity) {
        for (MemberModel member : entity.getMembers()) {
            this.visitMember(member);
        }
        if (entity.getVar() != null) {
            this.visitVar(entity.getVar());
        }
        if (entity.getPrimaryKey() != null) {
            this.visitPrimaryKey(entity.getPrimaryKey());
        }
        if (entity.getReadsets() != null) {
            this.visitReadsets(entity.getReadsets());
        }
        if (entity.getUpdatesets() != null) {
            this.visitUpdatesets(entity.getUpdatesets());
        }
        for (QueryModel query : entity.getQueryDefs()) {
            this.visitQuery(query);
        }
        for (IndexModel index : entity.getIndexs()) {
            this.visitIndex(index);
        }
    }

    @Override
    public final void visitIndex(IndexModel index) {
        this.m_parents.push(index);
        this.visitIndexChildren(index);
        this.m_parents.pop();
    }

    protected void visitIndexChildren(IndexModel index) {
    }

    @Override
    public final void visitMember(MemberModel member) {
        this.m_parents.push(member);
        this.visitMemberChildren(member);
        this.m_parents.pop();
    }

    protected void visitMemberChildren(MemberModel member) {
    }

    @Override
    public final void visitParam(ParamModel param) {
        this.m_parents.push(param);
        this.visitParamChildren(param);
        this.m_parents.pop();
    }

    protected void visitParamChildren(ParamModel param) {
    }

    @Override
    public final void visitPrimaryKey(PrimaryKeyModel primaryKey) {
        this.m_parents.push(primaryKey);
        this.visitPrimaryKeyChildren(primaryKey);
        this.m_parents.pop();
    }

    protected void visitPrimaryKeyChildren(PrimaryKeyModel primaryKey) {
    }

    @Override
    public final void visitQuery(QueryModel query) {
        this.m_parents.push(query);
        this.visitQueryChildren(query);
        this.m_parents.pop();
    }

    protected void visitQueryChildren(QueryModel query) {
        if (query.getParam() != null) {
            this.visitParam(query.getParam());
        }
    }

    @Override
    public final void visitReadset(ReadsetModel readset) {
        this.m_parents.push(readset);
        this.visitReadsetChildren(readset);
        this.m_parents.pop();
    }

    protected void visitReadsetChildren(ReadsetModel readset) {
    }

    @Override
    public final void visitReadsets(ReadsetsModel readsets) {
        this.m_parents.push(readsets);
        this.visitReadsetsChildren(readsets);
        this.m_parents.pop();
    }

    protected void visitReadsetsChildren(ReadsetsModel readsets) {
        if (readsets.getReadset() != null) {
            this.visitReadset(readsets.getReadset());
        }
    }

    @Override
    public final void visitUpdateset(UpdatesetModel updateset) {
        this.m_parents.push(updateset);
        this.visitUpdatesetChildren(updateset);
        this.m_parents.pop();
    }

    protected void visitUpdatesetChildren(UpdatesetModel updateset) {
    }

    @Override
    public final void visitUpdatesets(UpdatesetsModel updatesets) {
        this.m_parents.push(updatesets);
        this.visitUpdatesetsChildren(updatesets);
        this.m_parents.pop();
    }

    protected void visitUpdatesetsChildren(UpdatesetsModel updatesets) {
        if (updatesets.getUpdateset() != null) {
            this.visitUpdateset(updatesets.getUpdateset());
        }
    }

    @Override
    public final void visitVar(VarModel var) {
        this.m_parents.push(var);
        this.visitVarChildren(var);
        this.m_parents.pop();
    }

    protected void visitVarChildren(VarModel var) {
    }
}

