/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test.meta.transform;

import org.unidal.dal.jdbc.test.meta.entity.EntitiesModel;
import org.unidal.dal.jdbc.test.meta.entity.EntityModel;
import org.unidal.dal.jdbc.test.meta.entity.IndexModel;
import org.unidal.dal.jdbc.test.meta.entity.MemberModel;
import org.unidal.dal.jdbc.test.meta.entity.ParamModel;
import org.unidal.dal.jdbc.test.meta.entity.PrimaryKeyModel;
import org.unidal.dal.jdbc.test.meta.entity.QueryModel;
import org.unidal.dal.jdbc.test.meta.entity.ReadsetModel;
import org.unidal.dal.jdbc.test.meta.entity.ReadsetsModel;
import org.unidal.dal.jdbc.test.meta.entity.UpdatesetModel;
import org.unidal.dal.jdbc.test.meta.entity.UpdatesetsModel;
import org.unidal.dal.jdbc.test.meta.entity.VarModel;
import org.unidal.dal.jdbc.test.meta.transform.IMaker;
import org.xml.sax.Attributes;

public class DefaultSaxMaker
implements IMaker<Attributes> {
    @Override
    public EntitiesModel buildEntities(Attributes attributes) {
        EntitiesModel entities = new EntitiesModel();
        return entities;
    }

    @Override
    public EntityModel buildEntity(Attributes attributes) {
        String name = attributes.getValue("name");
        String table = attributes.getValue("table");
        String alias = attributes.getValue("alias");
        EntityModel entity = new EntityModel();
        if (name != null) {
            entity.setName(name);
        }
        if (table != null) {
            entity.setTable(table);
        }
        if (alias != null) {
            entity.setAlias(alias);
        }
        return entity;
    }

    @Override
    public IndexModel buildIndex(Attributes attributes) {
        String name = attributes.getValue("name");
        String members = attributes.getValue("members");
        String unique = attributes.getValue("unique");
        IndexModel index = new IndexModel();
        if (name != null) {
            index.setName(name);
        }
        if (members != null) {
            index.setMembers(members);
        }
        if (unique != null) {
            index.setUnique(this.convert(Boolean.class, unique, null));
        }
        return index;
    }

    @Override
    public MemberModel buildMember(Attributes attributes) {
        String name = attributes.getValue("name");
        String field = attributes.getValue("field");
        String valueType = attributes.getValue("value-type");
        String length = attributes.getValue("length");
        String nullable = attributes.getValue("nullable");
        String key = attributes.getValue("key");
        String autoIncrement = attributes.getValue("auto-increment");
        String insertExpr = attributes.getValue("insert-expr");
        String updateExpr = attributes.getValue("update-expr");
        MemberModel member = new MemberModel();
        if (name != null) {
            member.setName(name);
        }
        if (field != null) {
            member.setField(field);
        }
        if (valueType != null) {
            member.setValueType(valueType);
        }
        if (length != null) {
            member.setLength(this.convert(Integer.class, length, null));
        }
        if (nullable != null) {
            member.setNullable(this.convert(Boolean.class, nullable, null));
        }
        if (key != null) {
            member.setKey(this.convert(Boolean.class, key, null));
        }
        if (autoIncrement != null) {
            member.setAutoIncrement(this.convert(Boolean.class, autoIncrement, null));
        }
        if (insertExpr != null) {
            member.setInsertExpr(insertExpr);
        }
        if (updateExpr != null) {
            member.setUpdateExpr(updateExpr);
        }
        return member;
    }

    @Override
    public ParamModel buildParam(Attributes attributes) {
        String name = attributes.getValue("name");
        ParamModel param = new ParamModel();
        if (name != null) {
            param.setName(name);
        }
        return param;
    }

    @Override
    public PrimaryKeyModel buildPrimaryKey(Attributes attributes) {
        String name = attributes.getValue("name");
        String members = attributes.getValue("members");
        PrimaryKeyModel primaryKey = new PrimaryKeyModel();
        if (name != null) {
            primaryKey.setName(name);
        }
        if (members != null) {
            primaryKey.setMembers(members);
        }
        return primaryKey;
    }

    @Override
    public QueryModel buildQuery(Attributes attributes) {
        String name = attributes.getValue("name");
        String type = attributes.getValue("type");
        QueryModel query = new QueryModel();
        if (name != null) {
            query.setName(name);
        }
        if (type != null) {
            query.setType(type);
        }
        return query;
    }

    @Override
    public ReadsetModel buildReadset(Attributes attributes) {
        String name = attributes.getValue("name");
        String all = attributes.getValue("all");
        ReadsetModel readset = new ReadsetModel();
        if (name != null) {
            readset.setName(name);
        }
        if (all != null) {
            readset.setAll(this.convert(Boolean.class, all, null));
        }
        return readset;
    }

    @Override
    public ReadsetsModel buildReadsets(Attributes attributes) {
        ReadsetsModel readsets = new ReadsetsModel();
        return readsets;
    }

    @Override
    public UpdatesetModel buildUpdateset(Attributes attributes) {
        String name = attributes.getValue("name");
        String all = attributes.getValue("all");
        UpdatesetModel updateset = new UpdatesetModel();
        if (name != null) {
            updateset.setName(name);
        }
        if (all != null) {
            updateset.setAll(this.convert(Boolean.class, all, null));
        }
        return updateset;
    }

    @Override
    public UpdatesetsModel buildUpdatesets(Attributes attributes) {
        UpdatesetsModel updatesets = new UpdatesetsModel();
        return updatesets;
    }

    @Override
    public VarModel buildVar(Attributes attributes) {
        String name = attributes.getValue("name");
        String valueType = attributes.getValue("value-type");
        String keyMember = attributes.getValue("key-member");
        VarModel var = new VarModel();
        if (name != null) {
            var.setName(name);
        }
        if (valueType != null) {
            var.setValueType(valueType);
        }
        if (keyMember != null) {
            var.setKeyMember(keyMember);
        }
        return var;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }
}

