/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test.meta.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.unidal.dal.jdbc.test.meta.IEntity;
import org.unidal.dal.jdbc.test.meta.entity.EntitiesModel;
import org.unidal.dal.jdbc.test.meta.entity.EntityModel;
import org.unidal.dal.jdbc.test.meta.entity.IndexModel;
import org.unidal.dal.jdbc.test.meta.entity.MemberModel;
import org.unidal.dal.jdbc.test.meta.entity.ParamModel;
import org.unidal.dal.jdbc.test.meta.entity.PrimaryKeyModel;
import org.unidal.dal.jdbc.test.meta.entity.QueryModel;
import org.unidal.dal.jdbc.test.meta.entity.ReadsetModel;
import org.unidal.dal.jdbc.test.meta.entity.ReadsetsModel;
import org.unidal.dal.jdbc.test.meta.entity.UpdatesetModel;
import org.unidal.dal.jdbc.test.meta.entity.UpdatesetsModel;
import org.unidal.dal.jdbc.test.meta.entity.VarModel;
import org.unidal.dal.jdbc.test.meta.transform.DefaultLinker;
import org.unidal.dal.jdbc.test.meta.transform.DefaultSaxMaker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static EntitiesModel parse(InputSource is) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(EntitiesModel.class, is);
    }

    public static EntitiesModel parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(in));
    }

    public static EntitiesModel parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(reader));
    }

    public static EntitiesModel parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            Object currentObj = this.m_objs.pop();
            String currentTag = this.m_tags.pop();
            if (currentObj instanceof QueryModel) {
                QueryModel query = (QueryModel)currentObj;
                if ("statement".equals(currentTag)) {
                    query.setStatement(this.getText());
                }
            }
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForEntities(EntitiesModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"entity".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under entities!", qName));
        }
        EntityModel entity = this.m_maker.buildEntity(attributes);
        this.m_linker.onEntity(parentObj, entity);
        this.m_objs.push(entity);
        this.m_tags.push(qName);
    }

    private void parseForEntity(EntityModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("query-defs".equals(qName)) {
            this.m_objs.push(parentObj);
        } else if ("member".equals(qName)) {
            MemberModel member = this.m_maker.buildMember(attributes);
            this.m_linker.onMember(parentObj, member);
            this.m_objs.push(member);
        } else if ("var".equals(qName)) {
            VarModel var = this.m_maker.buildVar(attributes);
            this.m_linker.onVar(parentObj, var);
            this.m_objs.push(var);
        } else if ("primary-key".equals(qName)) {
            PrimaryKeyModel primaryKey = this.m_maker.buildPrimaryKey(attributes);
            this.m_linker.onPrimaryKey(parentObj, primaryKey);
            this.m_objs.push(primaryKey);
        } else if ("readsets".equals(qName)) {
            ReadsetsModel readsets = this.m_maker.buildReadsets(attributes);
            this.m_linker.onReadsets(parentObj, readsets);
            this.m_objs.push(readsets);
        } else if ("updatesets".equals(qName)) {
            UpdatesetsModel updatesets = this.m_maker.buildUpdatesets(attributes);
            this.m_linker.onUpdatesets(parentObj, updatesets);
            this.m_objs.push(updatesets);
        } else if ("query".equals(qName)) {
            QueryModel query = this.m_maker.buildQuery(attributes);
            this.m_linker.onQuery(parentObj, query);
            this.m_objs.push(query);
        } else if ("index".equals(qName)) {
            IndexModel index = this.m_maker.buildIndex(attributes);
            this.m_linker.onIndex(parentObj, index);
            this.m_objs.push(index);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under entity!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForIndex(IndexModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForMember(MemberModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForParam(ParamModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForPrimaryKey(PrimaryKeyModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForQuery(QueryModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("statement".equals(qName)) {
            this.m_objs.push(parentObj);
        } else if ("param".equals(qName)) {
            ParamModel param = this.m_maker.buildParam(attributes);
            this.m_linker.onParam(parentObj, param);
            this.m_objs.push(param);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under query!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForReadset(ReadsetModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForReadsets(ReadsetsModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"readset".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under readsets!", qName));
        }
        ReadsetModel readset = this.m_maker.buildReadset(attributes);
        this.m_linker.onReadset(parentObj, readset);
        this.m_objs.push(readset);
        this.m_tags.push(qName);
    }

    private void parseForUpdateset(UpdatesetModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForUpdatesets(UpdatesetsModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"updateset".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under updatesets!", qName));
        }
        UpdatesetModel updateset = this.m_maker.buildUpdateset(attributes);
        this.m_linker.onUpdateset(parentObj, updateset);
        this.m_objs.push(updateset);
        this.m_tags.push(qName);
    }

    private void parseForVar(VarModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("entities".equals(qName)) {
            EntitiesModel entities;
            this.m_entity = entities = this.m_maker.buildEntities(attributes);
            this.m_objs.push(entities);
            this.m_tags.push(qName);
        } else if ("entity".equals(qName)) {
            EntityModel entity;
            this.m_entity = entity = this.m_maker.buildEntity(attributes);
            this.m_objs.push(entity);
            this.m_tags.push(qName);
        } else if ("member".equals(qName)) {
            MemberModel member;
            this.m_entity = member = this.m_maker.buildMember(attributes);
            this.m_objs.push(member);
            this.m_tags.push(qName);
        } else if ("var".equals(qName)) {
            VarModel var;
            this.m_entity = var = this.m_maker.buildVar(attributes);
            this.m_objs.push(var);
            this.m_tags.push(qName);
        } else if ("primary-key".equals(qName)) {
            PrimaryKeyModel primaryKey;
            this.m_entity = primaryKey = this.m_maker.buildPrimaryKey(attributes);
            this.m_objs.push(primaryKey);
            this.m_tags.push(qName);
        } else if ("readsets".equals(qName)) {
            ReadsetsModel readsets;
            this.m_entity = readsets = this.m_maker.buildReadsets(attributes);
            this.m_objs.push(readsets);
            this.m_tags.push(qName);
        } else if ("readset".equals(qName)) {
            ReadsetModel readset;
            this.m_entity = readset = this.m_maker.buildReadset(attributes);
            this.m_objs.push(readset);
            this.m_tags.push(qName);
        } else if ("updatesets".equals(qName)) {
            UpdatesetsModel updatesets;
            this.m_entity = updatesets = this.m_maker.buildUpdatesets(attributes);
            this.m_objs.push(updatesets);
            this.m_tags.push(qName);
        } else if ("updateset".equals(qName)) {
            UpdatesetModel updateset;
            this.m_entity = updateset = this.m_maker.buildUpdateset(attributes);
            this.m_objs.push(updateset);
            this.m_tags.push(qName);
        } else if ("query".equals(qName)) {
            QueryModel query;
            this.m_entity = query = this.m_maker.buildQuery(attributes);
            this.m_objs.push(query);
            this.m_tags.push(qName);
        } else if ("param".equals(qName)) {
            ParamModel param;
            this.m_entity = param = this.m_maker.buildParam(attributes);
            this.m_objs.push(param);
            this.m_tags.push(qName);
        } else if ("index".equals(qName)) {
            IndexModel index;
            this.m_entity = index = this.m_maker.buildIndex(attributes);
            this.m_objs.push(index);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = this.m_tags.peek();
            if (parent instanceof EntitiesModel) {
                this.parseForEntities((EntitiesModel)parent, tag, qName, attributes);
            } else if (parent instanceof EntityModel) {
                this.parseForEntity((EntityModel)parent, tag, qName, attributes);
            } else if (parent instanceof MemberModel) {
                this.parseForMember((MemberModel)parent, tag, qName, attributes);
            } else if (parent instanceof VarModel) {
                this.parseForVar((VarModel)parent, tag, qName, attributes);
            } else if (parent instanceof PrimaryKeyModel) {
                this.parseForPrimaryKey((PrimaryKeyModel)parent, tag, qName, attributes);
            } else if (parent instanceof ReadsetsModel) {
                this.parseForReadsets((ReadsetsModel)parent, tag, qName, attributes);
            } else if (parent instanceof ReadsetModel) {
                this.parseForReadset((ReadsetModel)parent, tag, qName, attributes);
            } else if (parent instanceof UpdatesetsModel) {
                this.parseForUpdatesets((UpdatesetsModel)parent, tag, qName, attributes);
            } else if (parent instanceof UpdatesetModel) {
                this.parseForUpdateset((UpdatesetModel)parent, tag, qName, attributes);
            } else if (parent instanceof QueryModel) {
                this.parseForQuery((QueryModel)parent, tag, qName, attributes);
            } else if (parent instanceof ParamModel) {
                this.parseForParam((ParamModel)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof IndexModel)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForIndex((IndexModel)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

