/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.test.meta.transform;

import java.util.Map;
import org.unidal.dal.jdbc.test.meta.BaseEntity;
import org.unidal.dal.jdbc.test.meta.IEntity;
import org.unidal.dal.jdbc.test.meta.IVisitor;
import org.unidal.dal.jdbc.test.meta.entity.EntitiesModel;
import org.unidal.dal.jdbc.test.meta.entity.EntityModel;
import org.unidal.dal.jdbc.test.meta.entity.IndexModel;
import org.unidal.dal.jdbc.test.meta.entity.MemberModel;
import org.unidal.dal.jdbc.test.meta.entity.ParamModel;
import org.unidal.dal.jdbc.test.meta.entity.PrimaryKeyModel;
import org.unidal.dal.jdbc.test.meta.entity.QueryModel;
import org.unidal.dal.jdbc.test.meta.entity.ReadsetModel;
import org.unidal.dal.jdbc.test.meta.entity.ReadsetsModel;
import org.unidal.dal.jdbc.test.meta.entity.UpdatesetModel;
import org.unidal.dal.jdbc.test.meta.entity.UpdatesetsModel;
import org.unidal.dal.jdbc.test.meta.entity.VarModel;

public class DefaultXmlBuilder
implements IVisitor {
    private IVisitor m_visitor = this;
    private int m_level;
    private StringBuilder m_sb;
    private boolean m_compact;

    public DefaultXmlBuilder() {
        this(false);
    }

    public DefaultXmlBuilder(boolean compact) {
        this(compact, new StringBuilder(4096));
    }

    public DefaultXmlBuilder(boolean compact, StringBuilder sb) {
        this.m_compact = compact;
        this.m_sb = sb;
        this.m_sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
    }

    public String buildXml(IEntity<?> entity) {
        entity.accept(this.m_visitor);
        return this.m_sb.toString();
    }

    protected void endTag(String name) {
        --this.m_level;
        this.indent();
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected String escape(Object value) {
        return this.escape(value, false);
    }

    protected String escape(Object value, boolean text) {
        if (value == null) {
            return null;
        }
        String str = value.toString();
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 16);
        block6: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (!text) {
                        sb.append("&quot;");
                        continue block6;
                    }
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected void indent() {
        if (!this.m_compact) {
            for (int i = this.m_level - 1; i >= 0; --i) {
                this.m_sb.append("   ");
            }
        }
    }

    protected void startTag(String name) {
        this.startTag(name, false, null, new Object[0]);
    }

    protected void startTag(String name, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, (Object)null, closed, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, (Object)null, false, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Object text, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                this.m_sb.append(' ').append(e.getKey()).append("=\"").append(this.escape(e.getValue())).append('\"');
            }
        }
        if (text != null && closed) {
            this.m_sb.append('>');
            this.m_sb.append(this.escape(text, true));
            this.m_sb.append("</").append(name).append(">\r\n");
        } else {
            if (closed) {
                this.m_sb.append('/');
            } else {
                ++this.m_level;
            }
            this.m_sb.append(">\r\n");
        }
    }

    protected void tagWithText(String name, String text, Object ... nameValues) {
        if (text == null) {
            return;
        }
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        this.m_sb.append(">");
        this.m_sb.append(this.escape(text, true));
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected void element(String name, String text, boolean escape) {
        if (text == null) {
            return;
        }
        this.indent();
        this.m_sb.append('<').append(name).append(">");
        if (escape) {
            this.m_sb.append(this.escape(text, true));
        } else {
            this.m_sb.append("<![CDATA[").append(text).append("]]>");
        }
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    @Override
    public void visitEntities(EntitiesModel entities) {
        this.startTag("entities", null, new Object[0]);
        if (!entities.getEntities().isEmpty()) {
            for (EntityModel entity : entities.getEntities().toArray(new EntityModel[0])) {
                entity.accept(this.m_visitor);
            }
        }
        this.endTag("entities");
    }

    @Override
    public void visitEntity(EntityModel entity) {
        this.startTag("entity", null, "name", entity.getName(), "table", entity.getTable(), "alias", entity.getAlias());
        if (!entity.getMembers().isEmpty()) {
            for (MemberModel memberModel : entity.getMembers().toArray(new MemberModel[0])) {
                memberModel.accept(this.m_visitor);
            }
        }
        if (entity.getVar() != null) {
            entity.getVar().accept(this.m_visitor);
        }
        if (entity.getPrimaryKey() != null) {
            entity.getPrimaryKey().accept(this.m_visitor);
        }
        if (entity.getReadsets() != null) {
            entity.getReadsets().accept(this.m_visitor);
        }
        if (entity.getUpdatesets() != null) {
            entity.getUpdatesets().accept(this.m_visitor);
        }
        if (!entity.getQueryDefs().isEmpty()) {
            this.startTag("query-defs");
            for (BaseEntity baseEntity : entity.getQueryDefs().toArray(new QueryModel[0])) {
                ((QueryModel)baseEntity).accept(this.m_visitor);
            }
            this.endTag("query-defs");
        }
        if (!entity.getIndexs().isEmpty()) {
            for (BaseEntity baseEntity : entity.getIndexs().toArray(new IndexModel[0])) {
                ((IndexModel)baseEntity).accept(this.m_visitor);
            }
        }
        this.endTag("entity");
    }

    @Override
    public void visitIndex(IndexModel index) {
        this.startTag("index", true, null, "name", index.getName(), "members", index.getMembers(), "unique", index.getUnique());
    }

    @Override
    public void visitMember(MemberModel member) {
        this.startTag("member", true, null, "name", member.getName(), "field", member.getField(), "value-type", member.getValueType(), "length", member.getLength(), "nullable", member.getNullable(), "key", member.getKey(), "auto-increment", member.getAutoIncrement(), "insert-expr", member.getInsertExpr(), "update-expr", member.getUpdateExpr());
    }

    @Override
    public void visitParam(ParamModel param) {
        this.startTag("param", true, null, "name", param.getName());
    }

    @Override
    public void visitPrimaryKey(PrimaryKeyModel primaryKey) {
        this.startTag("primary-key", true, null, "name", primaryKey.getName(), "members", primaryKey.getMembers());
    }

    @Override
    public void visitQuery(QueryModel query) {
        this.startTag("query", null, "name", query.getName(), "type", query.getType());
        this.element("statement", query.getStatement(), true);
        if (query.getParam() != null) {
            query.getParam().accept(this.m_visitor);
        }
        this.endTag("query");
    }

    @Override
    public void visitReadset(ReadsetModel readset) {
        this.startTag("readset", true, null, "name", readset.getName(), "all", readset.getAll());
    }

    @Override
    public void visitReadsets(ReadsetsModel readsets) {
        this.startTag("readsets", null, new Object[0]);
        if (readsets.getReadset() != null) {
            readsets.getReadset().accept(this.m_visitor);
        }
        this.endTag("readsets");
    }

    @Override
    public void visitUpdateset(UpdatesetModel updateset) {
        this.startTag("updateset", true, null, "name", updateset.getName(), "all", updateset.getAll());
    }

    @Override
    public void visitUpdatesets(UpdatesetsModel updatesets) {
        this.startTag("updatesets", null, new Object[0]);
        if (updatesets.getUpdateset() != null) {
            updatesets.getUpdateset().accept(this.m_visitor);
        }
        this.endTag("updatesets");
    }

    @Override
    public void visitVar(VarModel var) {
        this.startTag("var", true, null, "name", var.getName(), "value-type", var.getValueType(), "key-member", var.getKeyMember());
    }
}

