/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.transaction;

import com.dianping.cat.Cat;
import java.sql.Connection;
import java.sql.SQLException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.datasource.DataSource;
import org.unidal.dal.jdbc.datasource.DataSourceManager;
import org.unidal.dal.jdbc.engine.QueryContext;
import org.unidal.dal.jdbc.mapping.TableProvider;
import org.unidal.dal.jdbc.mapping.TableProviderManager;
import org.unidal.dal.jdbc.transaction.TransactionManager;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TransactionManager.class)
public class DefaultTransactionManager
implements TransactionManager,
LogEnabled {
    private static ThreadLocalTransactionInfo m_threadLocalData = new ThreadLocalTransactionInfo();
    @Inject
    private TableProviderManager m_tableProviderManager;
    @Inject
    private DataSourceManager m_dataSourceManager;
    private Logger m_logger;

    @Override
    public void closeConnection() {
        TransactionInfo trxInfo = (TransactionInfo)m_threadLocalData.get();
        if (!trxInfo.isInTransaction()) {
            try {
                trxInfo.reset();
            }
            catch (SQLException e) {
                this.m_logger.warn("Error when closing Connection, message: " + e, (Throwable)e);
            }
        }
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void commitTransaction() {
        TransactionInfo trxInfo = (TransactionInfo)m_threadLocalData.get();
        if (!trxInfo.isInTransaction()) {
            throw new DalRuntimeException("There is no active transaction open, can't commit");
        }
        try {
            if (trxInfo.getConnection() != null) {
                trxInfo.getConnection().commit();
            }
        }
        catch (SQLException e) {
            throw new DalRuntimeException("Unable to commit transaction, message: " + e, e);
        }
        finally {
            try {
                trxInfo.reset();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public Connection getConnection(QueryContext ctx) {
        String logicalName = ctx.getEntityInfo().getLogicalName();
        TableProvider tableProvider = this.m_tableProviderManager.getTableProvider(logicalName);
        String dataSourceName = tableProvider.getDataSourceName(ctx.getQueryHints(), logicalName);
        TransactionInfo trxInfo = (TransactionInfo)m_threadLocalData.get();
        ctx.setDataSourceName(dataSourceName);
        if (trxInfo.isInTransaction()) {
            if (dataSourceName.equals(trxInfo.getDataSourceName())) {
                return trxInfo.getConnection();
            }
            throw new DalRuntimeException("Only one datasource can participate in a transaction. Now: " + trxInfo.getDataSourceName() + ", you provided: " + dataSourceName);
        }
        DataSource dataSource = this.m_dataSourceManager.getDataSource(dataSourceName);
        Connection connection = null;
        SQLException exception = null;
        try {
            connection = trxInfo.getConnection();
            if (connection == null) {
                connection = dataSource.getConnection();
            }
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            exception = e;
        }
        if (exception != null) {
            this.closeConnection(connection);
            this.m_logger.warn(String.format("Iffy database(%s) connection closed, try to reconnect.", dataSourceName), (Throwable)exception);
            try {
                connection = dataSource.getConnection();
                connection.setAutoCommit(true);
                exception = null;
            }
            catch (SQLException e) {
                this.closeConnection(connection);
                this.m_logger.warn(String.format("Unable to reconnect to database(%s).", dataSourceName), (Throwable)e);
            }
        }
        if (exception != null) {
            throw new DalRuntimeException("Error when getting connection from DataSource(" + dataSourceName + "), message: " + exception, exception);
        }
        trxInfo.setConnection(connection);
        trxInfo.setDataSourceName(dataSourceName);
        trxInfo.setInTransaction(false);
        return connection;
    }

    @Override
    public boolean isInTransaction() {
        TransactionInfo trxInfo = (TransactionInfo)m_threadLocalData.get();
        return trxInfo.isInTransaction();
    }

    @Override
    public void rollbackTransaction() {
        TransactionInfo trxInfo = (TransactionInfo)m_threadLocalData.get();
        if (!trxInfo.isInTransaction()) {
            throw new DalRuntimeException("There is no active transaction open, can't rollback");
        }
        try {
            if (trxInfo.getConnection() != null) {
                trxInfo.getConnection().rollback();
            }
        }
        catch (SQLException e) {
            throw new DalRuntimeException("Unable to rollback transaction, message: " + e, e);
        }
        finally {
            try {
                trxInfo.reset();
            }
            catch (SQLException e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    @Override
    public void startTransaction(String datasource) {
        TransactionInfo trxInfo = (TransactionInfo)m_threadLocalData.get();
        if (trxInfo.isInTransaction()) {
            throw new DalRuntimeException("Can't start transaction while another transaction has not been committed or rollbacked!");
        }
        DataSource ds = this.m_dataSourceManager.getDataSource(datasource);
        Connection connection = null;
        try {
            connection = ds.getConnection();
            connection.setAutoCommit(false);
            trxInfo.setConnection(connection);
            trxInfo.setDataSourceName(datasource);
            trxInfo.setInTransaction(true);
        }
        catch (SQLException e) {
            this.closeConnection(connection);
            throw new DalRuntimeException("Error when getting connection from DataSource(" + datasource + "), message: " + e, e);
        }
    }

    static class TransactionInfo {
        private String m_dataSourceName;
        private Connection m_connection;
        private boolean m_inTransaction;

        TransactionInfo() {
        }

        public Connection getConnection() {
            return this.m_connection;
        }

        public String getDataSourceName() {
            return this.m_dataSourceName;
        }

        public boolean isInTransaction() {
            try {
                if (this.m_connection != null && this.m_connection.isClosed()) {
                    return false;
                }
            }
            catch (SQLException e) {
                Cat.logError((Throwable)e);
            }
            return this.m_inTransaction;
        }

        public void reset() throws SQLException {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
            this.m_connection = null;
            this.m_dataSourceName = null;
            this.m_inTransaction = false;
            m_threadLocalData.remove();
        }

        public void setConnection(Connection connection) {
            this.m_connection = connection;
        }

        public void setDataSourceName(String dataSourceName) {
            this.m_dataSourceName = dataSourceName;
        }

        public void setInTransaction(boolean inTransaction) {
            this.m_inTransaction = inTransaction;
        }
    }

    static class ThreadLocalTransactionInfo
    extends ThreadLocal<TransactionInfo> {
        ThreadLocalTransactionInfo() {
        }

        @Override
        protected TransactionInfo initialValue() {
            return new TransactionInfo();
        }
    }
}

