/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos;

import com.alibaba.cloud.nacos.NacosPropertiesPrefixProvider;
import com.alibaba.cloud.nacos.utils.StringUtils;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

public final class NacosPropertiesPrefixer {
    public static final String PREFIX = NacosPropertiesPrefixer.getPrefixFromSpi();

    private NacosPropertiesPrefixer() {
    }

    private static String getPrefixFromSpi() {
        ServiceLoader<NacosPropertiesPrefixProvider> load = ServiceLoader.load(NacosPropertiesPrefixProvider.class);
        Iterator<NacosPropertiesPrefixProvider> iterator = load.iterator();
        if (iterator.hasNext()) {
            NacosPropertiesPrefixProvider provider = iterator.next();
            return provider.getPrefix();
        }
        return "";
    }

    public static String getPrefix(Environment environment) {
        String prefix = "spring.nacos";
        String prefixFromProperties = environment.getProperty("spring.nacos.properties.prefix");
        if (StringUtils.isBlank(prefixFromProperties)) {
            if (StringUtils.isNotBlank(PREFIX)) {
                prefix = PREFIX;
            }
        } else {
            prefix = prefixFromProperties;
        }
        if (StringUtils.isNotBlank(prefix) && prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    public static String getPrefix(Binder binder) {
        String prefix = "spring.nacos";
        BindResult bind = binder.bind("spring.nacos.properties.prefix", String.class);
        if (!bind.isBound()) {
            if (StringUtils.isNotBlank(PREFIX)) {
                prefix = PREFIX;
            }
        } else {
            prefix = (String)bind.get();
        }
        if (StringUtils.isNotBlank(prefix) && prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }
}

