/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.endpoint;

import com.alibaba.cloud.nacos.NacosConfigEnabledCondition;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.endpoint.NacosConfigEndpoint;
import com.alibaba.cloud.nacos.endpoint.NacosConfigHealthIndicator;
import com.alibaba.cloud.nacos.refresh.NacosRefreshHistory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

@ConditionalOnWebApplication
@ConditionalOnClass(value={Endpoint.class})
@Conditional(value={NacosConfigEnabledCondition.class})
public class NacosConfigEndpointAutoConfiguration {
    @Autowired
    private NacosConfigManager nacosConfigManager;
    @Autowired
    private NacosRefreshHistory nacosRefreshHistory;

    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    @Bean
    public NacosConfigEndpoint nacosConfigEndpoint() {
        return new NacosConfigEndpoint(this.nacosConfigManager.getNacosConfigProperties(), this.nacosRefreshHistory);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledHealthIndicator(value="nacos-config")
    public NacosConfigHealthIndicator nacosConfigHealthIndicator() {
        return new NacosConfigHealthIndicator(this.nacosConfigManager.getConfigService());
    }
}

