/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.unsafe;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.unsafe.UnsafeUtil;
import java.io.InputStream;

public class UnsafeInput
extends Input {
    public UnsafeInput() {
    }

    public UnsafeInput(int bufferSize) {
        super(bufferSize);
    }

    public UnsafeInput(byte[] buffer) {
        super(buffer);
    }

    public UnsafeInput(byte[] buffer, int offset, int count) {
        super(buffer, offset, count);
    }

    public UnsafeInput(InputStream inputStream) {
        super(inputStream);
    }

    public UnsafeInput(InputStream inputStream, int bufferSize) {
        super(inputStream, bufferSize);
    }

    @Override
    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        return UnsafeUtil.unsafe.getByte(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position++) & 0xFF;
    }

    @Override
    public byte readByte() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        return UnsafeUtil.unsafe.getByte(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position++);
    }

    @Override
    public int readByteUnsigned() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        return UnsafeUtil.unsafe.getByte(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position++) & 0xFF;
    }

    @Override
    public int readInt() throws KryoException {
        this.require(4);
        int result = UnsafeUtil.unsafe.getInt(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 4;
        return result;
    }

    @Override
    public long readLong() throws KryoException {
        this.require(8);
        long result = UnsafeUtil.unsafe.getLong(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 8;
        return result;
    }

    @Override
    public float readFloat() throws KryoException {
        this.require(4);
        float result = UnsafeUtil.unsafe.getFloat(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 4;
        return result;
    }

    @Override
    public double readDouble() throws KryoException {
        this.require(8);
        double result = UnsafeUtil.unsafe.getDouble(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 8;
        return result;
    }

    @Override
    public short readShort() throws KryoException {
        this.require(2);
        short result = UnsafeUtil.unsafe.getShort(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 2;
        return result;
    }

    @Override
    public char readChar() throws KryoException {
        this.require(2);
        char result = UnsafeUtil.unsafe.getChar(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 2;
        return result;
    }

    @Override
    public boolean readBoolean() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        boolean result = UnsafeUtil.unsafe.getByte(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position++) != 0;
        return result;
    }

    @Override
    public int[] readInts(int length) throws KryoException {
        int[] array = new int[length];
        this.readBytes(array, UnsafeUtil.intArrayBaseOffset, length << 2);
        return array;
    }

    @Override
    public long[] readLongs(int length) throws KryoException {
        long[] array = new long[length];
        this.readBytes(array, UnsafeUtil.longArrayBaseOffset, length << 3);
        return array;
    }

    @Override
    public float[] readFloats(int length) throws KryoException {
        float[] array = new float[length];
        this.readBytes(array, UnsafeUtil.floatArrayBaseOffset, length << 2);
        return array;
    }

    @Override
    public double[] readDoubles(int length) throws KryoException {
        double[] array = new double[length];
        this.readBytes(array, UnsafeUtil.doubleArrayBaseOffset, length << 3);
        return array;
    }

    @Override
    public short[] readShorts(int length) throws KryoException {
        short[] array = new short[length];
        this.readBytes(array, UnsafeUtil.shortArrayBaseOffset, length << 1);
        return array;
    }

    @Override
    public char[] readChars(int length) throws KryoException {
        char[] array = new char[length];
        this.readBytes(array, UnsafeUtil.charArrayBaseOffset, length << 1);
        return array;
    }

    @Override
    public boolean[] readBooleans(int length) throws KryoException {
        boolean[] array = new boolean[length];
        this.readBytes(array, UnsafeUtil.booleanArrayBaseOffset, length);
        return array;
    }

    @Override
    public void readBytes(byte[] bytes, int offset, int count) throws KryoException {
        this.readBytes((Object)bytes, UnsafeUtil.byteArrayBaseOffset + (long)offset, count);
    }

    public void readBytes(Object to, long offset, int count) throws KryoException {
        int copyCount = Math.min(this.limit - this.position, count);
        while (true) {
            UnsafeUtil.unsafe.copyMemory(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, to, offset, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) break;
            offset += (long)copyCount;
            copyCount = Math.min(count, this.capacity);
            this.require(copyCount);
        }
    }
}

