/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaProductService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopAddGoodsSkuData;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopAddGoodsSpuData;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopGetBrandResponse;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopGetCategoryResponse;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopGetFrightTemplateResponse;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopResult;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopSku;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopSkuListResponse;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopSpu;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopSpuGetResponse;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopSpuListResponse;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopUpdateGoodsSkuData;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopSpuPageRequest;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopBaseResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.chanjar.weixin.common.bean.result.WxMinishopImageUploadResult;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.MinishopUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaProductServiceImpl
implements WxMaProductService {
    private static final Logger log = LoggerFactory.getLogger(WxMaProductServiceImpl.class);
    private static final String ERR_CODE = "errcode";
    private final WxMaService wxMaService;

    @Override
    public WxMinishopImageUploadResult uploadImg(File file, Integer respType, Integer width, Integer height) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/img/upload?upload_type=0&height=" + height + "&width=" + width + "&resp_type=" + respType;
        WxMinishopImageUploadResult result = (WxMinishopImageUploadResult)this.wxMaService.execute(MinishopUploadRequestExecutor.create((RequestHttp)this.wxMaService.getRequestHttp()), url, file);
        return result;
    }

    @Override
    public WxMinishopImageUploadResult uploadImg(String imgUrl, Integer respType) throws WxErrorException {
        JsonObject jsonObject = GsonHelper.buildJsonObject((Object[])new Object[]{"img_url", imgUrl});
        String url = "https://api.weixin.qq.com/product/img/upload?upload_type=1&resp_type=" + respType;
        String response = this.wxMaService.post(url, jsonObject);
        JsonObject respObj = GsonParser.parse((String)response);
        if (respObj.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        return WxMinishopImageUploadResult.fromJson((String)response);
    }

    @Override
    public WxMinishopGetCategoryResponse getCategory(Integer fCatId) throws WxErrorException {
        JsonObject jsonObject = GsonHelper.buildJsonObject((Object[])new Object[]{"f_cat_id", fCatId});
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/category/get", jsonObject);
        JsonObject respObj = GsonParser.parse((String)response);
        if (respObj.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        return (WxMinishopGetCategoryResponse)WxMaGsonBuilder.create().fromJson(response, WxMinishopGetCategoryResponse.class);
    }

    @Override
    public WxMinishopGetBrandResponse getBrand() throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/brand/get", new Object());
        JsonObject respObj = GsonParser.parse((String)response);
        if (respObj.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        return (WxMinishopGetBrandResponse)WxMaGsonBuilder.create().fromJson(response, WxMinishopGetBrandResponse.class);
    }

    @Override
    public WxMinishopGetFrightTemplateResponse getFreightTemplate() throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/delivery/get_freight_template", new Object());
        JsonObject respObj = GsonParser.parse((String)response);
        if (respObj.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        return (WxMinishopGetFrightTemplateResponse)WxMaGsonBuilder.create().fromJson(response, WxMinishopGetFrightTemplateResponse.class);
    }

    @Override
    public WxMinishopResult<WxMinishopAddGoodsSpuData> addSpu(WxMinishopSpu spu) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/spu/add", spu);
        JsonObject respObj = GsonParser.parse((String)response);
        if (respObj.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        WxMinishopResult<WxMinishopAddGoodsSpuData> result = new WxMinishopResult<WxMinishopAddGoodsSpuData>();
        result.setErrcode(respObj.get(ERR_CODE).getAsInt());
        JsonObject dataObj = respObj.get("data").getAsJsonObject();
        WxMinishopAddGoodsSpuData resultData = new WxMinishopAddGoodsSpuData();
        resultData.setProductId(dataObj.get("product_id").getAsLong());
        resultData.setOutProductId(dataObj.get("out_product_id").getAsString());
        resultData.setCreateTime(dataObj.get("create_time").getAsString());
        result.setData(resultData);
        return result;
    }

    @Override
    public WxMaShopBaseResponse deleteSpu(Integer productId, String outProductId) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/product/spu/del", GsonHelper.buildJsonObject((Object[])new Object[]{"product_id", productId, "out_product_id", outProductId}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMinishopSpuGetResponse getSpu(Integer productId, String outProductId, Integer needEditSpu) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/spu/get", GsonHelper.buildJsonObject((Object[])new Object[]{"product_id", productId, "out_product_id", outProductId, "need_edit_spu", needEditSpu}));
        JsonObject jsonObject = GsonParser.parse((String)response);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        return (WxMinishopSpuGetResponse)WxMaGsonBuilder.create().fromJson(response, WxMinishopSpuGetResponse.class);
    }

    @Override
    public WxMinishopSpuListResponse getSpuList(WxMaShopSpuPageRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/product/spu/get_list", request);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMinishopSpuListResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMinishopSpuListResponse.class);
    }

    @Override
    public WxMinishopResult<WxMinishopAddGoodsSpuData> updateSpu(WxMinishopSpu spu) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/spu/update", spu);
        JsonObject respObj = GsonParser.parse((String)response);
        if (respObj.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        WxMinishopResult<WxMinishopAddGoodsSpuData> result = new WxMinishopResult<WxMinishopAddGoodsSpuData>();
        result.setErrcode(respObj.get(ERR_CODE).getAsInt());
        JsonObject dataObj = respObj.get("data").getAsJsonObject();
        WxMinishopAddGoodsSpuData resultData = new WxMinishopAddGoodsSpuData();
        resultData.setProductId(dataObj.get("product_id").getAsLong());
        resultData.setOutProductId(dataObj.get("out_product_id").getAsString());
        resultData.setUpdateTime(dataObj.get("update_time").getAsString());
        result.setData(resultData);
        return result;
    }

    @Override
    public WxMaShopBaseResponse listingSpu(Integer productId, String outProductId) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/product/spu/listing", GsonHelper.buildJsonObject((Object[])new Object[]{"product_id", productId, "out_product_id", outProductId}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopBaseResponse delistingSpu(Integer productId, String outProductId) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/product/spu/delisting", GsonHelper.buildJsonObject((Object[])new Object[]{"product_id", productId, "out_product_id", outProductId}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMinishopSkuListResponse getSkuList(Long productId, Integer needRealStock, Integer needEditSku) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/product/sku/get_list", GsonHelper.buildJsonObject((Object[])new Object[]{"product_id", productId, "need_edit_sku", needEditSku, "need_real_stock", needRealStock}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMinishopSkuListResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMinishopSkuListResponse.class);
    }

    @Override
    public WxMinishopResult<WxMinishopAddGoodsSkuData> minishiopGoodsAddSku(WxMinishopSku sku) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/sku/add", sku);
        JsonObject jsonObject = GsonParser.parse((String)response);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        WxMinishopResult<WxMinishopAddGoodsSkuData> result = new WxMinishopResult<WxMinishopAddGoodsSkuData>();
        result.setErrcode(jsonObject.get(ERR_CODE).getAsInt());
        JsonObject dataObj = jsonObject.get("data").getAsJsonObject();
        WxMinishopAddGoodsSkuData resultData = new WxMinishopAddGoodsSkuData();
        resultData.setSkuId(dataObj.get("sku_id").getAsLong());
        resultData.setCreateTime(dataObj.get("create_time").getAsString());
        result.setData(resultData);
        return result;
    }

    @Override
    public WxMinishopResult<List<WxMinishopAddGoodsSkuData>> minishopGoodsBatchAddSku(List<WxMinishopSku> skuList) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/sku/batch_add", GsonHelper.buildJsonObject((Object[])new Object[]{"skus", skuList}));
        JsonObject jsonObject = GsonParser.parse((String)response);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        WxMinishopResult<List<WxMinishopAddGoodsSkuData>> result = new WxMinishopResult<List<WxMinishopAddGoodsSkuData>>();
        result.setErrcode(jsonObject.get(ERR_CODE).getAsInt());
        JsonArray jsonArray = jsonObject.get("data").getAsJsonArray();
        ArrayList<WxMinishopAddGoodsSkuData> skuData = new ArrayList<WxMinishopAddGoodsSkuData>();
        for (JsonElement jsonElement : jsonArray) {
            JsonObject element = jsonElement.getAsJsonObject();
            WxMinishopAddGoodsSkuData resultData = new WxMinishopAddGoodsSkuData();
            resultData.setSkuId(element.get("sku_id").getAsLong());
            resultData.setOutSkuId(element.get("out_sku_id").getAsString());
            resultData.setCreateTime(element.get("create_time").getAsString());
            skuData.add(resultData);
        }
        result.setData(skuData);
        return result;
    }

    @Override
    public WxMaShopBaseResponse minishopGoodsDelSku(Long productId, Long outProductId, String outSkuId, Long skuId) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/sku/del", GsonHelper.buildJsonObject((Object[])new Object[]{"product_id", productId, "out_product_id", outProductId, "out_sku_id", outSkuId, "sku_id", skuId}));
        JsonObject jsonObject = GsonParser.parse((String)response);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(response, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMinishopResult<WxMinishopUpdateGoodsSkuData> minishopGoodsUpdateSku(WxMinishopSku sku) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/sku/update", sku);
        JsonObject jsonObject = GsonParser.parse((String)response);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        WxMinishopResult<WxMinishopUpdateGoodsSkuData> result = new WxMinishopResult<WxMinishopUpdateGoodsSkuData>();
        result.setErrcode(jsonObject.get(ERR_CODE).getAsInt());
        JsonObject dataObj = jsonObject.get("data").getAsJsonObject();
        WxMinishopUpdateGoodsSkuData resultData = new WxMinishopUpdateGoodsSkuData();
        resultData.setUpdateTime(dataObj.get("update_time").getAsString());
        result.setData(resultData);
        return result;
    }

    @Override
    public WxMinishopResult<WxMinishopUpdateGoodsSkuData> minishopGoodsUpdateSkuPrice(Long productId, String outProductId, String outSkuId, Long skuId, Long salePrice, Long marketPrice) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/sku/update_price", GsonHelper.buildJsonObject((Object[])new Object[]{"product_id", productId, "out_product_id", outProductId, "sku_id", skuId, "out_sku_id", outSkuId, "sale_price", salePrice, "market_price", marketPrice}));
        JsonObject jsonObject = GsonParser.parse((String)response);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        WxMinishopResult<WxMinishopUpdateGoodsSkuData> result = new WxMinishopResult<WxMinishopUpdateGoodsSkuData>();
        result.setErrcode(jsonObject.get(ERR_CODE).getAsInt());
        JsonObject dataObj = jsonObject.get("data").getAsJsonObject();
        WxMinishopUpdateGoodsSkuData resultData = new WxMinishopUpdateGoodsSkuData();
        resultData.setUpdateTime(dataObj.get("update_time").getAsString());
        result.setData(resultData);
        return result;
    }

    @Override
    public WxMinishopResult<WxMinishopUpdateGoodsSkuData> minishopGoodsUpdateSkuStock(Long productId, String outProductId, String outSkuId, Long skuId, Integer type, Integer stockNum) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/stock/update", GsonHelper.buildJsonObject((Object[])new Object[]{"product_id", productId, "out_product_id", outProductId, "sku_id", skuId, "out_sku_id", outSkuId, "type", type, "stock_num", stockNum}));
        JsonObject jsonObject = GsonParser.parse((String)response);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        WxMinishopResult<WxMinishopUpdateGoodsSkuData> result = new WxMinishopResult<WxMinishopUpdateGoodsSkuData>();
        result.setErrcode(jsonObject.get(ERR_CODE).getAsInt());
        JsonObject dataObj = jsonObject.get("data").getAsJsonObject();
        WxMinishopUpdateGoodsSkuData resultData = new WxMinishopUpdateGoodsSkuData();
        resultData.setUpdateTime(dataObj.get("update_time").getAsString());
        result.setData(resultData);
        return result;
    }

    public WxMaProductServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

