/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkText;
import com.qcloud.cos.model.ciModel.template.MediaWatermark;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class WatermarkJobDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        WatermarkJobDemo.createMediaJobs(client);
    }

    public static void createMediaJobs(COSClient client) throws UnsupportedEncodingException {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demobucket-1234567890");
        request.setTag("Transcode");
        request.getInput().setObject("1.mp4");
        MediaTranscodeObject transcode = request.getOperation().getTranscode();
        MediaContainerObject container = transcode.getContainer();
        container.setFormat("mp4");
        MediaTranscodeVideoObject video = transcode.getVideo();
        video.setCodec("H.264");
        video.setProfile("high");
        video.setBitrate("1000");
        video.setWidth("1280");
        video.setFps("30");
        video.setPreset("medium");
        video.setBufSize("0");
        video.setMaxrate("50000");
        MediaAudioObject audio = transcode.getAudio();
        audio.setCodec("aac");
        audio.setSamplerate("44100");
        audio.setBitrate("128");
        audio.setChannels("4");
        MediaTimeIntervalObject timeInterval = transcode.getTimeInterval();
        timeInterval.setStart("0");
        timeInterval.setDuration("60");
        List<MediaWatermark> watermarkList = request.getOperation().getWatermarkList();
        MediaWatermark waterMark = new MediaWatermark();
        waterMark.setType("Text");
        waterMark.setLocMode("Absolute");
        waterMark.setDx("128");
        waterMark.setDy("128");
        waterMark.setPos("TopRight");
        waterMark.setStartTime("0");
        waterMark.setEndTime("100.5");
        MediaWaterMarkText text = waterMark.getText();
        text.setText("\u6c34\u5370\u5185\u5bb9");
        text.setFontSize("30");
        text.setFontType("simfang.ttf");
        text.setFontColor("0x112233");
        text.setTransparency("30");
        watermarkList.add(waterMark);
        waterMark = new MediaWatermark();
        waterMark.setType("Text");
        waterMark.setLocMode("Absolute");
        waterMark.setDx("20");
        waterMark.setDy("20");
        waterMark.setPos("TopRight");
        waterMark.setStartTime("0");
        waterMark.setEndTime("100.5");
        text = waterMark.getText();
        text.setText("\u6c34\u5370\u5185\u5bb9");
        text.setFontSize("30");
        text.setFontType("simfang.ttf");
        text.setFontColor("0x112233");
        text.setTransparency("30");
        watermarkList.add(waterMark);
        request.getOperation().getOutput().setBucket("demobucket-1234567890");
        request.getOperation().getOutput().setRegion("ap-chongqing");
        request.getOperation().getOutput().setObject("watermark-demo.mp4");
        request.setQueueId("p9900025e4ec44b5e8225e70a521*****");
        MediaJobResponse response = client.createMediaJobs(request);
        System.out.println(response);
    }
}

