/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java;

import io.growing.sdk.java.constants.RunMode;
import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.dto.GioCDPMessage;
import io.growing.sdk.java.exception.GIOSendBeRejectedException;
import io.growing.sdk.java.logger.GioLogger;
import io.growing.sdk.java.sender.FixThreadPoolSender;
import io.growing.sdk.java.store.StoreStrategy;
import io.growing.sdk.java.store.StoreStrategyClient;
import io.growing.sdk.java.utils.ConfigUtils;
import io.growing.sdk.java.utils.StringUtils;
import io.growing.sdk.java.utils.VersionInfo;
import java.util.Properties;

public class GrowingAPI {
    private static final boolean validDefaultConfig;
    private final String projectKey;
    private final String dataSourceId;
    private static final StoreStrategy strategy;

    private GrowingAPI(Builder builder) {
        this.dataSourceId = builder.dataSourceId;
        this.projectKey = builder.projectKey;
    }

    private static boolean validDefaultConfig() {
        GioLogger.debug("growingio-java-sdk version is " + VersionInfo.getVersion() + ", running in mode: " + (Object)((Object)RunMode.getCurrentMode()));
        return RunMode.isTestMode() != false || FixThreadPoolSender.getNetProvider().connectedToGrowingAPIHost();
    }

    public void send(GIOMessage msg) {
        try {
            if (validDefaultConfig && this.businessVerification(msg)) {
                strategy.push(msg);
            }
        }
        catch (Exception e) {
            GioLogger.error("failed to send msg, " + e.toString());
        }
    }

    public void sendMaybeRejected(GIOMessage msg) throws GIOSendBeRejectedException {
        try {
            if (validDefaultConfig && this.businessVerification(msg)) {
                strategy.push(msg);
            }
        }
        catch (GIOSendBeRejectedException e) {
            throw e;
        }
        catch (Exception e) {
            GioLogger.error("failed to send msg, " + e.toString());
        }
    }

    private boolean businessVerification(GIOMessage msg) {
        if (!StringUtils.nonBlank(this.projectKey)) {
            GioLogger.error("projectKey cant be null or empty string");
            return false;
        }
        msg.setProjectKey(this.projectKey);
        if (msg instanceof GioCDPMessage) {
            if (StringUtils.nonBlank(this.dataSourceId)) {
                ((GioCDPMessage)msg).setDataSourceId(this.dataSourceId);
            } else {
                GioLogger.error("cdp message datasourceId cant be null or empty string");
                return false;
            }
        }
        return true;
    }

    public static void initConfig(String configFilePath) {
        ConfigUtils.init(configFilePath);
    }

    public static void initConfig(Properties properties) {
        ConfigUtils.init(properties);
    }

    static {
        strategy = StoreStrategyClient.getStoreInstance(StoreStrategyClient.CURRENT_STRATEGY);
        ConfigUtils.initDefault();
        validDefaultConfig = GrowingAPI.validDefaultConfig();
    }

    public static class Builder {
        private String dataSourceId;
        private String projectKey;

        public Builder setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public Builder setProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public GrowingAPI build() {
            return new GrowingAPI(this);
        }
    }
}

