/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.constants;

import io.growing.sdk.java.utils.ConfigUtils;

public enum RunMode {
    TEST("test"),
    PRODUCTION("production");

    private final String value;
    private static RunMode currentMode;

    private RunMode(String value) {
        this.value = value;
    }

    public static RunMode getByValue(String value) {
        for (RunMode mode : RunMode.values()) {
            if (!mode.value.equals(value)) continue;
            return mode;
        }
        return TEST;
    }

    public static RunMode getCurrentMode() {
        if (currentMode == null) {
            currentMode = RunMode.getByValue(ConfigUtils.getStringValue("run.mode", "test"));
        }
        return currentMode;
    }

    public static Boolean isTestMode() {
        return currentMode == TEST;
    }

    public static Boolean isProductionMode() {
        return currentMode == PRODUCTION;
    }
}

