/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.dto;

import io.growing.collector.tunnel.protocol.EventDto;
import io.growing.collector.tunnel.protocol.ItemDto;
import io.growing.sdk.java.dto.GioCDPMessage;
import java.io.Serializable;
import java.util.Map;

public class GioCdpEventMessage
extends GioCDPMessage<EventDto>
implements Serializable {
    private static final long serialVersionUID = -5228910337644290100L;
    private final EventDto event;

    private GioCdpEventMessage(EventDto.Builder builder) {
        this.event = builder.setTimestamp(this.getTimeStampOrDefault(builder.getTimestamp())).setType(EventDto.EventType.CUSTOM_EVENT).build();
    }

    @Override
    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    @Override
    public EventDto getMessage() {
        return this.event.toBuilder().setProjectKey(this.projectKey).setDataSourceId(this.dataSourceId).build();
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public static final class Builder {
        private final EventDto.Builder builder = EventDto.newBuilder();

        public GioCdpEventMessage build() {
            return new GioCdpEventMessage(this.builder);
        }

        public Builder eventTime(long eventTime) {
            this.builder.setTimestamp(eventTime);
            return this;
        }

        public Builder eventKey(String eventKey) {
            this.builder.setEventKey(eventKey);
            return this;
        }

        public Builder loginUserId(String loginUserId) {
            this.builder.setUserId(loginUserId);
            return this;
        }

        public Builder anonymousId(String anonymousId) {
            this.builder.setAnonymousId(anonymousId);
            return this;
        }

        @Deprecated
        public Builder eventNumValue(Number numValue) {
            double value;
            if (numValue != null && (value = numValue.doubleValue()) >= 0.0) {
                this.builder.setEventNum(value);
            }
            return this;
        }

        public Builder addEventVariable(String key, Integer value) {
            this.addVariableObject(key, value);
            return this;
        }

        public Builder addEventVariable(String key, Double value) {
            this.addVariableObject(key, value);
            return this;
        }

        public Builder addEventVariable(String key, String value) {
            this.addVariableObject(key, value);
            return this;
        }

        public Builder addEventVariables(Map<String, Object> variables) {
            if (variables != null && !variables.isEmpty()) {
                for (Map.Entry<String, Object> entry : variables.entrySet()) {
                    this.addVariableObject(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public Builder addItem(String id, String key) {
            this.builder.setItem(ItemDto.newBuilder().setId(id).setKey(key).build());
            return this;
        }

        private Builder addVariableObject(String key, Object value) {
            if (key != null && value != null) {
                key = key.trim();
                if (value instanceof String) {
                    String val = value.toString();
                    if (val.length() > 255) {
                        this.builder.putAttributes(key, val.substring(0, 255));
                    } else {
                        this.builder.putAttributes(key, String.valueOf(value));
                    }
                } else {
                    this.builder.putAttributes(key, String.valueOf(value));
                }
            }
            return this;
        }
    }
}

