/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.dto;

import io.growing.collector.tunnel.protocol.UserDto;
import io.growing.sdk.java.dto.GioCDPMessage;
import java.io.Serializable;
import java.util.Map;

public class GioCdpUserMessage
extends GioCDPMessage<UserDto>
implements Serializable {
    private static final long serialVersionUID = -5228910337644290100L;
    private UserDto user;

    private GioCdpUserMessage(UserDto.Builder builder) {
        this.user = builder.setTimestamp(this.getTimeStampOrDefault(builder.getTimestamp())).build();
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    @Override
    public UserDto getMessage() {
        return this.user.toBuilder().setProjectKey(this.projectKey).setDataSourceId(this.dataSourceId).build();
    }

    public static final class Builder {
        private UserDto.Builder builder = UserDto.newBuilder();

        public GioCdpUserMessage build() {
            return new GioCdpUserMessage(this.builder);
        }

        public Builder time(long timestamp) {
            this.builder.setTimestamp(timestamp);
            return this;
        }

        public Builder loginUserId(String loginUserId) {
            this.builder.setUserId(loginUserId);
            this.builder.setGioId(loginUserId);
            return this;
        }

        public Builder anonymousId(String anonymousId) {
            this.builder.setAnonymousId(anonymousId);
            return this;
        }

        public Builder addUserVariable(String key, String value) {
            this.addVariableObject(key, value);
            return this;
        }

        public Builder addUserVariable(String key, int value) {
            this.addVariableObject(key, value);
            return this;
        }

        public Builder addUserVariable(String key, double value) {
            this.addVariableObject(key, value);
            return this;
        }

        private Builder addVariableObject(String key, Object value) {
            if (key != null && value != null) {
                key = key.trim();
                if (value instanceof String) {
                    String val = value.toString();
                    if (val.length() > 255) {
                        this.builder.putAttributes(key, val.substring(0, 255));
                    } else {
                        this.builder.putAttributes(key, String.valueOf(value));
                    }
                } else {
                    this.builder.putAttributes(key, String.valueOf(value));
                }
            }
            return this;
        }

        public Builder addUserVariables(Map<String, Object> variables) {
            if (variables != null && !variables.isEmpty()) {
                for (Map.Entry<String, Object> entry : variables.entrySet()) {
                    this.addVariableObject(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }
    }
}

