/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.logger;

import io.growing.sdk.java.logger.GioLoggerImpl;
import io.growing.sdk.java.logger.GioLoggerInterface;
import io.growing.sdk.java.utils.ConfigUtils;

public class GioLogger {
    private static GioLoggerInterface logger;
    private static final String loggerLevel;

    private static GioLoggerInterface getDefaultLogger() {
        return new GioLoggerImpl();
    }

    public static void debug(String msg) {
        if (!loggerLevel.equals("error")) {
            logger.debug(msg);
        }
    }

    public static void error(String msg) {
        logger.error(msg);
    }

    static {
        String loggerImplName = ConfigUtils.getStringValue("logger.implementation", "io.growing.sdk.java.logger.GioLoggerImpl");
        loggerLevel = ConfigUtils.getStringValue("logger.level", "error");
        try {
            Class<?> loggerImplClass = Class.forName(loggerImplName);
            logger = (GioLoggerInterface)loggerImplClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger = GioLogger.getDefaultLogger();
            logger.error("use gio logger, cause failed to find logger implementation class " + loggerImplName);
        }
        catch (IllegalAccessException e) {
            logger = GioLogger.getDefaultLogger();
            logger.error("use gio logger, cause failed to construct logger implementation class " + loggerImplName);
        }
        catch (InstantiationException e) {
            logger = GioLogger.getDefaultLogger();
            logger.error("use gio logger, cause failed to instantiate logger implementation class " + loggerImplName);
        }
    }
}

