/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.process.impl;

import com.google.protobuf.Message;
import io.growing.collector.tunnel.protocol.EventList;
import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.dto.GioCdpEventMessage;
import io.growing.sdk.java.process.MessageProcessor;
import io.growing.sdk.java.process.impl.ProtobufMessage;
import io.growing.sdk.java.sender.net.ContentTypeEnum;
import java.util.List;
import java.util.Map;

public class GioCdpEventMessageProcessor
extends ProtobufMessage
implements MessageProcessor {
    @Override
    public String apiHost(String ai) {
        return this.apiDomain() + "/projects/" + ai + "/collect/cstm";
    }

    @Override
    public ContentTypeEnum contentType() {
        return ContentTypeEnum.PROTOBUF;
    }

    @Override
    public Map<String, String> headers() {
        return HEADERS;
    }

    @Override
    public GIOMessage skipIllegalMessage(GIOMessage gioMessage) {
        return gioMessage;
    }

    @Override
    protected byte[] doProcess(List<GIOMessage> msgList) {
        EventList list = this.getEvents(msgList);
        return list == null ? null : list.toByteArray();
    }

    private EventList getEvents(List<GIOMessage> msgList) {
        EventList.Builder listBuilder = EventList.newBuilder();
        for (GIOMessage msg : msgList) {
            if (!(msg instanceof GioCdpEventMessage)) continue;
            GioCdpEventMessage cdp = (GioCdpEventMessage)msg;
            listBuilder.addValues(cdp.getMessage());
        }
        if (listBuilder.getValuesCount() > 0) {
            return listBuilder.build();
        }
        return null;
    }

    @Override
    protected String debugMessage(List<GIOMessage> msgList) {
        return this.toJson((Message)this.getEvents(msgList));
    }
}

