/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.process.impl;

import com.google.protobuf.Message;
import io.growing.collector.tunnel.protocol.UserList;
import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.dto.GioCdpUserMessage;
import io.growing.sdk.java.process.MessageProcessor;
import io.growing.sdk.java.process.impl.ProtobufMessage;
import io.growing.sdk.java.sender.net.ContentTypeEnum;
import java.util.List;
import java.util.Map;

public class GioCdpUserMessageProcessor
extends ProtobufMessage
implements MessageProcessor {
    @Override
    public String apiHost(String ai) {
        return this.apiDomain() + "/projects/" + ai + "/collect/user";
    }

    @Override
    public ContentTypeEnum contentType() {
        return ContentTypeEnum.PROTOBUF;
    }

    @Override
    public Map<String, String> headers() {
        return HEADERS;
    }

    @Override
    public GIOMessage skipIllegalMessage(GIOMessage gioMessage) {
        return gioMessage;
    }

    @Override
    protected byte[] doProcess(List<GIOMessage> msgList) {
        UserList list = this.getUsers(msgList);
        return list == null ? null : list.toByteArray();
    }

    private UserList getUsers(List<GIOMessage> msgList) {
        UserList.Builder listBuilder = UserList.newBuilder();
        for (GIOMessage msg : msgList) {
            if (!(msg instanceof GioCdpUserMessage)) continue;
            GioCdpUserMessage cdp = (GioCdpUserMessage)msg;
            listBuilder.addValues(cdp.getMessage());
        }
        if (listBuilder.getValuesCount() > 0) {
            return listBuilder.build();
        }
        return null;
    }

    @Override
    protected String debugMessage(List<GIOMessage> msgList) {
        return this.toJson((Message)this.getUsers(msgList));
    }
}

