/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.process.impl;

import io.growing.sdk.java.dto.GIOEventMessage;
import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.logger.GioLogger;
import io.growing.sdk.java.process.MessageProcessor;
import io.growing.sdk.java.process.compression.CompressionTool;
import io.growing.sdk.java.process.compression.impl.GioSnappy;
import io.growing.sdk.java.process.impl.AbstractMessageProcessor;
import io.growing.sdk.java.sender.net.ContentTypeEnum;
import io.growing.sdk.java.utils.ConfigUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class GioEventMessageProcessor
extends AbstractMessageProcessor
implements MessageProcessor {
    private static final List<String> INVALID_CS1_VALUE = Arrays.asList("0", "1", "-1");
    private static final int STRING_VALUE_LENGTH_LIMIT = 255;
    private static final CompressionTool compress = new GioSnappy();
    private static final Boolean compressConfig = ConfigUtils.getBooleanValue("compress", Boolean.TRUE);

    @Override
    public String apiHost(String ai) {
        return this.apiDomain() + "/v3/" + ai + "/s2s/cstm?stm=" + System.currentTimeMillis();
    }

    @Override
    public ContentTypeEnum contentType() {
        return ContentTypeEnum.JSON;
    }

    @Override
    public Map<String, String> headers() {
        if (compressConfig.booleanValue()) {
            HEADERS.put("X-Compress-Codec", "2");
        } else {
            HEADERS.put("X-Compress-Codec", "0");
        }
        return HEADERS;
    }

    @Override
    public GIOMessage skipIllegalMessage(GIOMessage gioMessage) {
        GIOEventMessage eventMessage = (GIOEventMessage)gioMessage;
        if (eventMessage.getN() == null) {
            GioLogger.error("event key cant be null ");
            return null;
        }
        int nLength = eventMessage.getN().length();
        if (nLength == 0 || nLength > 255) {
            GioLogger.error("event key length must be between 1 and 255 ");
            return null;
        }
        if (eventMessage.getCs1() != null) {
            int cs1Length = eventMessage.getCs1().length();
            if (cs1Length == 0 || cs1Length > 255) {
                GioLogger.error("event loginUserId length must be between 1 and 255 ");
                return null;
            }
            if (INVALID_CS1_VALUE.contains(eventMessage.getCs1())) {
                GioLogger.error("event loginUserId cant contains " + eventMessage.getCs1());
                return null;
            }
            if (eventMessage.getCs1().contains(":")) {
                GioLogger.error("event loginUserId cant contains [:]" + eventMessage.getCs1());
                return null;
            }
        }
        return gioMessage;
    }

    @Override
    protected byte[] doProcess(List<GIOMessage> msgList) {
        String json = this.toJson(msgList);
        if (json != null) {
            byte[] bytes = json.getBytes();
            if (compressConfig.booleanValue()) {
                return compress.compress(bytes);
            }
            return bytes;
        }
        return null;
    }

    private String toJson(List<GIOMessage> msgList) {
        JSONArray jsonArray = new JSONArray();
        for (GIOMessage msg : msgList) {
            if (!(msg instanceof GIOEventMessage)) continue;
            GIOEventMessage event = (GIOEventMessage)msg;
            jsonArray.put((Object)new JSONObject(event.getMapResult()));
        }
        if (jsonArray.length() > 0) {
            return jsonArray.toString();
        }
        return null;
    }

    @Override
    protected String debugMessage(List<GIOMessage> msgList) {
        return this.toJson(msgList);
    }
}

