/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.sender;

import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.process.EventProcessorClient;
import io.growing.sdk.java.process.MessageProcessor;
import io.growing.sdk.java.sender.MessageSender;
import io.growing.sdk.java.sender.RequestDto;
import io.growing.sdk.java.sender.net.HttpUrlProvider;
import io.growing.sdk.java.sender.net.NetProviderAbstract;
import io.growing.sdk.java.thread.GioThreadNamedFactory;
import io.growing.sdk.java.utils.ConfigUtils;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FixThreadPoolSender
implements MessageSender {
    private static final ExecutorService sendThread = Executors.newFixedThreadPool(ConfigUtils.getIntValue("send.msg.thread", 3), new GioThreadNamedFactory("gio-sender"));
    private static final NetProviderAbstract netProvider = new HttpUrlProvider();

    @Override
    public void sendMsg(String projectKey, List<GIOMessage> msg) {
        this.doSend(projectKey, msg);
    }

    public static NetProviderAbstract getNetProvider() {
        return netProvider;
    }

    public void doSend(final String projectKey, final List<GIOMessage> msgList) {
        if (null != msgList && !msgList.isEmpty()) {
            sendThread.execute(new Runnable(){

                @Override
                public void run() {
                    for (MessageProcessor processor : EventProcessorClient.getProcessors()) {
                        byte[] processed = processor.process(msgList);
                        if (processed == null || processed.length <= 0) continue;
                        RequestDto requestDto = new RequestDto.Builder().setUrl(processor.apiHost(projectKey)).setContentType(processor.contentType()).setBytes(processed).setHeaders(processor.headers()).build();
                        FixThreadPoolSender.getNetProvider().toSend(requestDto);
                    }
                }
            });
        }
    }
}

