/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.sender.net;

import io.growing.sdk.java.logger.GioLogger;
import io.growing.sdk.java.sender.RequestDto;
import io.growing.sdk.java.sender.net.NetProviderAbstract;
import io.growing.sdk.java.utils.ConfigUtils;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpUrlProvider
extends NetProviderAbstract {
    @Override
    protected int sendPost(RequestDto requestDto) {
        try {
            return this.doSend(requestDto);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                return this.retry(requestDto);
            }
            return 400;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectedToGrowingAPIHost() {
        InputStream inputStream = null;
        String checkHealthyUrl = ConfigUtils.getStringValue("api.host", "");
        try {
            HttpURLConnection httpConn = this.getConnection(checkHealthyUrl);
            httpConn.setRequestMethod("GET");
            httpConn.setConnectTimeout(HttpUrlProvider.getConnectionTimeout());
            httpConn.setReadTimeout(HttpUrlProvider.getReadTimeout());
            httpConn.connect();
            httpConn.getResponseCode();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            GioLogger.error("failed to connect " + checkHealthyUrl + ", cause " + e.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doSend(RequestDto requestDto) throws Exception {
        HttpURLConnection httpConn = this.getConnection(requestDto.getUrl());
        this.setHttpConnHeaders(httpConn, requestDto.getHeaders());
        httpConn.setRequestProperty("Content-Type", requestDto.getContentType().toString());
        httpConn.setUseCaches(false);
        httpConn.setRequestMethod("POST");
        httpConn.setConnectTimeout(HttpUrlProvider.getConnectionTimeout());
        httpConn.setReadTimeout(HttpUrlProvider.getReadTimeout());
        httpConn.setRequestProperty("Content-Length", String.valueOf(requestDto.getBytes().length));
        httpConn.setDoOutput(true);
        FilterOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            httpConn.connect();
            outputStream = new DataOutputStream(httpConn.getOutputStream());
            outputStream.write(requestDto.getBytes());
            ((DataOutputStream)outputStream).flush();
            int responseCode = httpConn.getResponseCode();
            inputStream = httpConn.getInputStream();
            int n = this.responseOk(responseCode);
            return n;
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void setHttpConnHeaders(HttpURLConnection httpConn, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpConn.setRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    private int responseOk(int responseCode) {
        if (responseCode < 200 || responseCode > 300) {
            GioLogger.error("growingio server return error " + responseCode);
        }
        return responseCode;
    }

    private int retry(RequestDto requestDto) {
        int retryTimes = 3;
        int responseCode = 0;
        for (int i = 0; i < retryTimes; ++i) {
            try {
                TimeUnit.SECONDS.sleep(1L);
                responseCode = this.doSend(requestDto);
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return responseCode;
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        Proxy proxy = NetProviderAbstract.ProxyInfo.getProxy();
        HttpURLConnection httpConn = proxy == null ? (HttpURLConnection)new URL(url).openConnection() : (HttpURLConnection)new URL(url).openConnection(proxy);
        return httpConn;
    }
}

