/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.sender.net;

import io.growing.sdk.java.constants.RunMode;
import io.growing.sdk.java.logger.GioLogger;
import io.growing.sdk.java.sender.RequestDto;
import io.growing.sdk.java.utils.ConfigUtils;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;

public abstract class NetProviderAbstract {
    protected static final Map<String, String> HTTP_HEADERS = new HashMap<String, String>();

    protected static int getConnectionTimeout() {
        return ConfigUtils.getIntValue("connection.timeout", 2000);
    }

    protected static int getReadTimeout() {
        return ConfigUtils.getIntValue("read.timeout", 2000);
    }

    public void toSend(RequestDto requestDto) {
        if (RunMode.isProductionMode().booleanValue()) {
            this.sendPost(requestDto);
        }
        GioLogger.debug(System.currentTimeMillis() + " message sent. " + requestDto.toString());
    }

    protected abstract int sendPost(RequestDto var1);

    public abstract boolean connectedToGrowingAPIHost();

    protected static class ProxyInfo {
        private static final Proxy proxy = ProxyInfo.setProxy();

        protected ProxyInfo() {
        }

        private static Proxy setProxy() {
            String proxyHost = ConfigUtils.getStringValue("proxy.host", null);
            Integer proxyPort = ConfigUtils.getIntValue("proxy.port", 80);
            if (proxyHost == null || proxyHost.isEmpty()) {
                return null;
            }
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)proxyPort));
        }

        private static void setAuthenticator() {
            final String proxyUser = ConfigUtils.getStringValue("proxy.user", null);
            final String proxyPassword = ConfigUtils.getStringValue("proxy.password", null);
            if (proxyUser != null && proxyPassword != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                });
            }
        }

        public static Proxy getProxy() {
            return proxy;
        }

        static {
            ProxyInfo.setAuthenticator();
        }
    }
}

