/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.store;

import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.exception.GIOSendBeRejectedException;
import io.growing.sdk.java.logger.GioLogger;
import io.growing.sdk.java.process.EventProcessorClient;
import io.growing.sdk.java.process.MessageProcessor;
import io.growing.sdk.java.store.StoreStrategy;
import io.growing.sdk.java.thread.GioThreadNamedFactory;
import io.growing.sdk.java.utils.ConfigUtils;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class StoreStrategyAbstract
implements StoreStrategy {
    private static ExecutorService pushMsgThreadPool = Executors.newSingleThreadExecutor(new GioThreadNamedFactory("gio-push-msg"));
    private static final int AWAIT = ConfigUtils.getIntValue("shutdown.await", 3);
    protected static BlockingQueue<GIOMessage> messageBlockingQueue;

    @Override
    public void push(final GIOMessage msg) {
        Future<?> resultFuture = pushMsgThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                MessageProcessor processor = EventProcessorClient.getApiInstance(msg);
                if (processor.skipIllegalMessage(msg) != null) {
                    StoreStrategyAbstract.this.doPush(msg);
                }
            }
        });
        try {
            resultFuture.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GIOSendBeRejectedException) {
                throw (GIOSendBeRejectedException)e.getCause();
            }
            GioLogger.error(e.getLocalizedMessage());
        }
        catch (Exception e) {
            GioLogger.error(e.getLocalizedMessage());
        }
    }

    public abstract void doPush(GIOMessage var1);

    @Override
    public void shutdownAwait() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (!messageBlockingQueue.isEmpty()) {
                    GioLogger.error("JVM hook was executed, msg queue size: " + messageBlockingQueue.size() + " is not empty, will wait it " + AWAIT + "s");
                    try {
                        TimeUnit.SECONDS.sleep(AWAIT);
                    }
                    catch (InterruptedException e) {
                        GioLogger.error(e.getLocalizedMessage());
                    }
                }
            }
        }));
    }
}

