/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.store;

import io.growing.sdk.java.constants.StoreStrategyEnum;
import io.growing.sdk.java.store.StoreStrategy;
import io.growing.sdk.java.store.impl.AbortPolicyStoreStrategy;
import io.growing.sdk.java.store.impl.DefaultStoreStrategy;
import io.growing.sdk.java.utils.ConfigUtils;

public class StoreStrategyClient {
    public static final StoreStrategyEnum CURRENT_STRATEGY = StoreStrategyEnum.getByValue(ConfigUtils.getStringValue("msg.store.strategy", "default"));

    public static StoreStrategy getStoreInstance(StoreStrategyEnum strategy) {
        StoreStrategy storeStrategy = strategy == StoreStrategyEnum.ABORT_POLICY ? StoreInstance.abortPolicyStoreStrategy : StoreInstance.defaultStoreStrategy;
        storeStrategy.shutdownAwait();
        return storeStrategy;
    }

    private static class StoreInstance {
        static StoreStrategy defaultStoreStrategy = new DefaultStoreStrategy();
        static StoreStrategy abortPolicyStoreStrategy = new AbortPolicyStoreStrategy();

        private StoreInstance() {
        }
    }
}

